CREATE PROCEDURE "dba"."convert_maksuvaba"( )
BEGIN
  -- isikliku maksuvaba nullimine 01.01.2026 aasta seisuga
  declare ll_asutnr integer;
  declare ll_skoop integer;
  declare ls_skoopkood char(16);
  declare ldc_mvaba integer;
  declare li_tk smallint;
  declare li_sots smallint;
  declare ld_kuup date;
  declare err_notfound exception for sqlstate value '02000';
  declare c_kaader_tun dynamic scroll cursor for
    select distinct pa_kaader_tun.asutnr,pa_kaader_tun.skoop,skoobid.kood
      from pa_kaader_tun left outer join skoobid on pa_kaader_tun.skoop=skoobid.skoop
      where "pa_kaader_tun"."mvaba">0 and "pa_kaader_tun"."tmt"=1 and "pa_kaader_tun"."kuup1"<=ld_kuup;
  -- kustuta maksuvabad summad, kui tulumaksu tunnus ei eelda maksuvaba
  update pa_kaader_tun set mvaba=0 where tmt is null or tmt<>1;
  -- kuupaev, mille suhtes nullitakse varasemad maksuvabad
  set ld_kuup=ymd(2026,1,1);
  -- tsykkel le tootajate koos valdkonnaga, kus on esinenud maksuvaba kasutamist
  open c_kaader_tun;
  kaader_tun_loop: loop
    fetch next c_kaader_tun into ll_asutnr,ll_skoop,ls_skoopkood;
    if sqlstate = err_notfound then -- kui eof
      leave kaader_tun_loop
    end if;
    -- arvuta viimane kehtiv maksuvaba
    set ldc_mvaba=get_pa_kaader_tun_mvaba(ll_asutnr,ld_kuup-1,ls_skoopkood);
    -- kui on suurem nullist
    if ldc_mvaba>0 then
      -- kui ei ole juba lisatud kannet uue kuupaevaga
      if not exists(select 1 from pa_kaader_tun where asutnr=ll_asutnr and kuup1=ld_kuup and skoop=ll_skoop) then
        -- arvuta varasemad tunnused
        set li_tk=get_pa_kaader_tun_tk(ll_asutnr,ld_kuup-1,ls_skoopkood);
        set li_sots=get_pa_kaader_tun_sots(ll_asutnr,ld_kuup-1,ls_skoopkood);
        -- lisa kanne null maksuvabaga samasse valdkonda
        insert into pa_kaader_tun(asutnr,kuup1,tmt,mvaba,tk,sots,skoop) values (ll_asutnr,ld_kuup,1,0,li_tk,li_sots,ll_skoop);
      end if
    end if;
  end loop kaader_tun_loop;
  close c_kaader_tun;
END