ALTER PROCEDURE "DBA"."dk_arvetas2017"(in id_obj integer,in a_perlop date)
begin
  declare ll_skoop integer;
  declare li_spank smallint;
  declare ls_dk_kontod char(7);
  declare ll_id integer;
  declare ll_id_asutnr integer;
  declare ll_asutnr integer;
  declare ldc_vahe decimal(15,2);
  declare ldc_koksumma decimal(15,2);
  declare ldc_summa decimal(15,2);
  declare err_notfound exception for sqlstate value '02000';
  declare c_arvetas2007 dynamic scroll cursor for
    select distinct asutnr from gl_dk_arvetas2007;
  declare c_arvetas dynamic scroll cursor for
    select id,arvesumma-makssumma from gl_dk_arvetas where asutnr=ll_asutnr and arvesumma<>0 order by arvekuup asc;
  select djkonto,spank,skoop into ls_dk_kontod,li_spank,ll_skoop from dk_obj where objnr=id_obj;
  delete from gl_dk_arvetas;
  -- arveldused
  insert into gl_dk_arvetas( asutnr,arvenr,arvekuup,arvesumma)
    select dk_kanne.asutnr,
           if dk_kanne.crekuup is null or dk_kanne.crenr is null then if dk_kanne.arvenr is null then '' else dk_kanne.arvenr endif else dk_kanne.crenr endif as dk_kanne_arvenr,
           if (dk_kanne.crekuup is null or dk_kanne.crenr is null) then (if dk_kanne.arvekuup is null then ymd(2000,1,1) else dk_kanne.arvekuup endif) else dk_kanne.crekuup endif as dk_kanne_arvekuup,
           sum(if dk_kanne.sisse=li_spank then -1*(dk_kanne.summa+dk_kanne.summa2) else (dk_kanne.summa+dk_kanne.summa2) endif)
      from dk_kanne key left outer join dk_obj
      where dk_kanne.objnr=id_obj and dk_kanne.asutnr>0 and dk_kanne.kuup<=a_perlop
      group by dk_kanne.asutnr,dk_kanne_arvekuup,dk_kanne_arvenr;
  -- kassa/pank
  insert into gl_dk_arvetas( asutnr,arvenr,arvekuup,makssumma)
    select kp_kanne.asutnr,
           if kp_kanne.arvenr is null then '' else kp_kanne.arvenr endif as kp_kanne_arvenr,
           if kp_kanne.arvekuup is null then ymd(2000,1,1) else kp_kanne.arvekuup endif as kp_kanne_arvekuup,
           sum(if kp_kanne.sisse=li_spank then -1*(kp_kanne.summa) else kp_kanne.summa endif)
      from kp_kanne key left outer join kp_obj
      where kp_obj.skoop=ll_skoop and kp_kanne.konto=ls_dk_kontod and kp_kanne.asutnr>0 and kp_kanne.kuup<=a_perlop
      group by kp_kanne.asutnr,kp_kanne_arvekuup,kp_kanne_arvenr;
  -- muuda puuduvad vaartused
  update gl_dk_arvetas set arvenr='' where arvenr is null;
  update gl_dk_arvetas set arvekuup=ymd(2000,1,1) where arvekuup is null;
  update gl_dk_arvetas set arvesumma=0 where arvesumma is null;
  update gl_dk_arvetas set makssumma=0 where makssumma is null;
  -- summeri yks arve yheks reaks
  delete from gl_dk_arvetas2007;
  insert into gl_dk_arvetas2007( asutnr,arvekuup,arvenr,arvesumma,makssumma)
    select gl_dk_arvetas.asutnr,gl_dk_arvetas.arvekuup,gl_dk_arvetas.arvenr,sum(gl_dk_arvetas.arvesumma),sum(gl_dk_arvetas.makssumma)
     from gl_dk_arvetas
     group by gl_dk_arvetas.asutnr,gl_dk_arvetas.arvekuup,gl_dk_arvetas.arvenr;
  -- kustuta null arved
  delete from gl_dk_kanne;
  insert into gl_dk_kanne( asutnr,arvekuup,arvenr,summa)
    select gl_dk_arvetas2007.asutnr,gl_dk_arvetas2007.arvekuup,gl_dk_arvetas2007.arvenr,sum(gl_dk_arvetas2007.arvesumma-gl_dk_arvetas2007.makssumma)
     from gl_dk_arvetas2007
     group by gl_dk_arvetas2007.asutnr,gl_dk_arvetas2007.arvekuup,gl_dk_arvetas2007.arvenr;
  delete gl_dk_arvetas2007 from gl_dk_arvetas2007 left outer join gl_dk_kanne on gl_dk_arvetas2007.asutnr=gl_dk_kanne.asutnr and gl_dk_arvetas2007.arvekuup=gl_dk_kanne.arvekuup and gl_dk_arvetas2007.arvenr=gl_dk_kanne.arvenr where gl_dk_kanne.summa=0;
  -- kustuta null asutus/isikud
  delete from gl_dk_kanne;
  insert into gl_dk_kanne( asutnr,summa)
    select gl_dk_arvetas2007.asutnr,sum(gl_dk_arvetas2007.arvesumma-gl_dk_arvetas2007.makssumma)
     from gl_dk_arvetas2007
     group by gl_dk_arvetas2007.asutnr;
  delete gl_dk_arvetas2007 from gl_dk_arvetas2007 left outer join gl_dk_kanne on gl_dk_arvetas2007.asutnr=gl_dk_kanne.asutnr where gl_dk_kanne.summa=0;
  -- nulli ettemakstud arved voi arve puudub
  update gl_dk_arvetas2007 set arvenr='',arvekuup=ymd(2000,1,1),arvesumma=0, makssumma=makssumma-arvesumma where makssumma>arvesumma or arvesumma=0;
  -- summeeri ettemaksu summa yhele reale
  delete gl_dk_arvetas;
  insert into gl_dk_arvetas(asutnr,arvenr,arvekuup,arvesumma,makssumma)
    select gl_dk_arvetas2007.asutnr,gl_dk_arvetas2007.arvenr,gl_dk_arvetas2007.arvekuup,sum(gl_dk_arvetas2007.arvesumma),sum(gl_dk_arvetas2007.makssumma)
      from gl_dk_arvetas2007
      group by gl_dk_arvetas2007.asutnr,gl_dk_arvetas2007.arvenr,gl_dk_arvetas2007.arvekuup;
  -- tsykkel yle asutus/isikute
  open c_arvetas2007;
  arvetas2007_loop: loop
    fetch next c_arvetas2007 into ll_asutnr;
    if sqlstate = err_notfound then -- kui eof
      leave arvetas2007_loop
    end if;
    -- leia yhe asutuse ettemaksu summa
    set ldc_koksumma=0;
    select first id,makssumma into ll_id_asutnr,ldc_koksumma from gl_dk_arvetas where asutnr=ll_asutnr and arvesumma=0;
    if ldc_koksumma is null then
      set ldc_koksumma=0
    end if;
    -- kui on ettemaks, siis jaga varasemate arvete peale
    if ldc_koksumma>0 then
      open c_arvetas;
      arvetas_loop: loop
        fetch next c_arvetas into ll_id,ldc_vahe;
        if sqlstate = err_notfound then -- kui eof
          leave arvetas_loop
        end if;
        -- kui ettemaksu summa kataba arve kinni
        if ldc_vahe<=ldc_koksumma then
          -- kustuta arve
          delete from gl_dk_arvetas where id=ll_id;
          -- vahenda ettemaksu
          set ldc_koksumma=ldc_koksumma-ldc_vahe
        end if    
      end loop arvetas_loop;
      close c_arvetas;
      -- kui ettemaksu ei jaa, siis kustuta ettemaksu kanne
      if ldc_koksumma=0 then
        delete from gl_dk_arvetas where id=ll_id_asutnr
      else
        -- muidu muuda ettemaksu summa
        update gl_dk_arvetas set makssumma=ldc_koksumma where id=ll_id_asutnr
      end if
    end if
  end loop arvetas2007_loop;
  close c_arvetas2007;
end