CREATE PROCEDURE "DBA"."dk_arvetasarno_web"(in as_arvenr varchar(20))
begin
    declare ll_asutnr integer;
    declare ld_arvekuup date;
    declare ls_djkonto varchar(7);
    declare ll_skoop integer;
    declare lc_arvesumma numeric(15,2);

    -- top 1 prast group by-d on igaks juhuks, et tehniliselt katki ei lheks (sisuliselt lheb)
    select top 1 k.asutnr, k.arvekuup, o.djkonto, o.skoop, sum(k.summa + k.summa2) 
        into ll_asutnr, ld_arvekuup, ls_djkonto, ll_skoop, lc_arvesumma
        from dk_kanne k join dk_obj o on k.objnr = o.objnr 
        where k.arvenr = as_arvenr and k.sisse = 1 and o.spank = 0
        group by k.asutnr, k.arvekuup, o.djkonto, o.skoop;
    
    if ll_asutnr is null then -- kui pole htegi kannet sellise mgiarve thisega, viga -1
        select as_arvenr as arvenr, -1 as onnestumine, null as tasutudsumma, current timestamp as seisuga, cast(null as numeric(15,2)) as arvesumma;
    end if;
    
    select as_arvenr as arvenr, 1 as onnestumine, coalesce(sum(k.summa),0) as tasutudsumma, 
        max(coalesce(k.kell2, k.kell)) as seisuga, lc_arvesumma as arvesumma
        from kp_kanne k join kp_obj o on k.objnr = o.objnr 
        where k.asutnr = ll_asutnr and k.arvekuup = ld_arvekuup and k.konto = ls_djkonto and o.skoop = ll_skoop;

end