ALTER PROCEDURE "dba"."dk_set_doknr"()
begin
  declare ls_doknr char(20);
  declare ll_objnr integer;
  declare li_years integer;
  declare ld_arvekuup date;
  declare ls_arvenr char(20);
  declare ll_asutnr integer;
  declare ll_saajanr integer;
  declare ll_panknr integer;
  declare ls_otseknr char(30);
  declare ls_ls_laps_info1 char(100);
  declare li_yksarve integer;
  declare li_yksinfo1 integer;
  declare err_notfound exception for sqlstate value '02000';
  select dk_konfm.yld_yksarve,dk_konfm.yld_yksinfo1 into li_yksarve,li_yksinfo1 from dk_konfm where dk_konfm.id = 1;
  gl_dk_kanne_loop: loop
    select first gl_dk_kanne.objnr,gl_dk_kanne.arvekuup,gl_dk_kanne.arvenr,gl_dk_kanne.asutnr,gl_dk_kanne.saajanr,gl_dk_kanne.panknr,gl_dk_kanne.sarve,gl_dk_kanne.ls_laps_info1
      into ll_objnr,ld_arvekuup,ls_arvenr,ll_asutnr,ll_saajanr,ll_panknr,ls_otseknr,ls_ls_laps_info1
      from gl_dk_kanne left outer join asulist on gl_dk_kanne.asutnr = asulist.asutnr
      where gl_dk_kanne.doknr is null
      order by gl_dk_kanne.taiendus asc, asulist.nimi asc;
    if sqlstate = err_notfound then -- kui eof
      leave gl_dk_kanne_loop
    end if;
    set li_years=Years(ld_arvekuup);
    set ls_doknr=get_doknr_dk(li_years,ll_objnr);
    update gl_dk_kanne
      set gl_dk_kanne.doknr = ls_doknr,
          gl_dk_kanne.arvenr = if gl_dk_kanne.arvenr is null then ls_doknr else gl_dk_kanne.arvenr endif
      where gl_dk_kanne.objnr = ll_objnr and
            gl_dk_kanne.arvekuup = ld_arvekuup and
           (gl_dk_kanne.arvenr = ls_arvenr or ls_arvenr is null or Trim(ls_arvenr) = '') and
            gl_dk_kanne.asutnr = ll_asutnr and
           (gl_dk_kanne.saajanr = ll_saajanr or (ll_saajanr is null and gl_dk_kanne.saajanr is null) or li_yksarve = 1) and
           (gl_dk_kanne.panknr = ll_panknr or ll_panknr is null) and
           (gl_dk_kanne.sarve = ls_otseknr or ls_otseknr is null or Trim(ls_otseknr) = '') and
           (gl_dk_kanne.ls_laps_info1 = ls_ls_laps_info1 or (ls_ls_laps_info1 is null and gl_dk_kanne.ls_laps_info1 is null) or Trim(ls_ls_laps_info1) = '' or li_yksinfo1=1);
    insert into dk_kanne( objnr,tulnud,sisse,kuup,summa,doknr,"info",konto,asutnr,kulnr,artnr,tulnr,alusnr,objectnr,user_code,arvekuup,arvenr,taskuup,viitnr,sarve,panknr,kogus,yhiknr,hind,kbnr,summa2,taiendus,saajanr,osaknr,subjectnr,suundnr,talnr,alliknr,ravonr,partnr,summa3,summa4,id_maks,meetnr,taotnr,id_earve,id_autoviivis,invoiceid,servicenr,crekuup,crenr,lisanr)
      select gl_dk_kanne.objnr,gl_dk_kanne.tulnud,gl_dk_kanne.sisse,gl_dk_kanne.kuup,gl_dk_kanne.summa,gl_dk_kanne.doknr,gl_dk_kanne.info,gl_dk_kanne.konto,gl_dk_kanne.asutnr,gl_dk_kanne.kulnr,gl_dk_kanne.artnr,gl_dk_kanne.tulnr,gl_dk_kanne.alusnr,gl_dk_kanne.objectnr,gl_dk_kanne.user_code,gl_dk_kanne.arvekuup,gl_dk_kanne.arvenr,gl_dk_kanne.taskuup,gl_dk_kanne.viitnr,gl_dk_kanne.sarve,gl_dk_kanne.panknr,gl_dk_kanne.kogus,gl_dk_kanne.yhiknr,gl_dk_kanne.hind,gl_dk_kanne.kbnr,gl_dk_kanne.summa2,gl_dk_kanne.taiendus,gl_dk_kanne.saajanr,gl_dk_kanne.osaknr,gl_dk_kanne.subjectnr,gl_dk_kanne.suundnr,gl_dk_kanne.talnr,gl_dk_kanne.alliknr,gl_dk_kanne.ravonr,gl_dk_kanne.partnr,gl_dk_kanne.summa3,gl_dk_kanne.summa4,gl_dk_kanne.id_maks,gl_dk_kanne.meetnr,gl_dk_kanne.taotnr,gl_dk_kanne.id_earve,gl_dk_kanne.id_autoviivis,gl_dk_kanne.invoiceid,gl_dk_kanne.servicenr,gl_dk_kanne.crekuup,gl_dk_kanne.crenr,lisanr
        from gl_dk_kanne where gl_dk_kanne.doknr is not null order by gl_dk_kanne.tulnud asc;
    delete from gl_dk_kanne where gl_dk_kanne.doknr is not null
  end loop gl_dk_kanne_loop
end