ALTER PROCEDURE "dba"."dk_taitur_koond"( in id_skoop integer,in id_obj integer,in id_paring integer,in peralg date,in perlop date,in a_form smallint,in a_taiturnr integer)
BEGIN
  declare ll_id unsigned integer;
  declare li_id integer;
  declare ll_jrknr integer;
  declare ld_arvekuup date;
  declare ld_akuup date;
  declare ld_lkuup date;
  declare ld_taskuup date;
  declare ls_arvenr char(20);
  declare ll_asutnr integer;
  declare ll_saajanr integer;
  declare ll_taiturnr integer;
  declare ll_tulnr integer;
  declare li_sisse smallint;
  declare ldc_summa numeric(15,2);
  declare ls_info char(400);
  declare ls_alus char(400);
  declare ls_laekus char(400);
  declare err_notfound exception for sqlstate value '02000';
  declare c_dk_taitur dynamic scroll cursor for
    select dk_taitur.id,
           dk_taitur.arvekuup,
           dk_taitur.arvenr,
           dk_taitur.asutnr,
           dk_taitur.taiturnr,
           dk_taitur.akuup,
           dk_taitur.lkuup,
           if dk_kanne.sisse=li_sisse then dk_kanne.summa + dk_kanne.summa2 else -1*(dk_kanne.summa + dk_kanne.summa2) endif,
           dk_kanne.taskuup,
           coalesce(dk_kanne.saajanr,0),
           Trim(menetlist.nimi+' '+dk_taitur."info"),
           Trim(dk_alus.nimi+' '+dk_kanne."info"),
           if dk_kanne.tulnr is null then 0 else dk_kanne.tulnr endif
      from dk_taitur left outer join menetlist on dk_taitur.menetnr=menetlist.menetnr
                     left outer join dk_kanne on dk_taitur.arvekuup=dk_kanne.arvekuup and dk_taitur.arvenr=dk_kanne.arvenr and dk_taitur.asutnr=dk_kanne.asutnr
                     left outer join dk_obj on dk_kanne.objnr=dk_obj.objnr
                     left outer join dk_alus on dk_kanne.alusnr=dk_alus.alusnr
    where (dk_kanne.objnr=id_obj or id_obj=0) and
          (dk_obj.skoop=id_skoop or id_skoop=0) and
           (dk_kanne.tulnr > 0 or dk_kanne.artnr > 0)  and
          (dk_taitur.taiturnr=a_taiturnr or a_taiturnr=0) and
           dk_taitur.akuup <= perlop and
          (dk_taitur.lkuup is null or dk_taitur.lkuup >= peralg) and
          (dk_taitur.akuup >= peralg or a_form <> 20) and
          (dk_taitur.lkuup<=perlop or a_form <> 21);

  declare c_gl_dk_taitur dynamic scroll cursor for
    select gl_dk_taitur."id",gl_dk_taitur."tulnr",trim(convert(char(15),kp_kanne.summa)) + ' ' + convert(char(10),kp_kanne.kuup,104),if kp_kanne.sisse=li_sisse then kp_kanne.summa else -1*kp_kanne.summa endif
      from gl_dk_taitur left outer join kp_kanne on gl_dk_taitur.arvekuup=kp_kanne.arvekuup and gl_dk_taitur.arvenr=kp_kanne.arvenr and gl_dk_taitur.asutnr=kp_kanne.asutnr and gl_dk_taitur.tulnr=kp_kanne.tulnr
                        left outer join kp_obj on kp_kanne.objnr=kp_obj.objnr
      where (kp_obj.skoop=id_skoop or id_skoop=0) and kp_kanne.summa is not null;

  declare c_gl_dk_jrknr dynamic scroll cursor for
    select gl_dk_taitur."id",gl_dk_taitur.jrknr
      from gl_dk_taitur
      order by get_asulist_nimi(gl_dk_taitur.asutnr) asc,arvekuup asc, "id" asc;

  delete from gl_dk_taitur;

  if id_obj > 0 then
    select if dk_obj.spank=1 then 0 else 1 endif into li_sisse from dk_obj where dk_obj.objnr=id_obj
  else
    set li_sisse = 1
  end if;

  open c_dk_taitur;
  dk_taitur_loop: loop
    --  loe taituri kanne
    fetch next c_dk_taitur into ll_id,ld_arvekuup,ls_arvenr,ll_asutnr,ll_taiturnr,ld_akuup,ld_lkuup,ldc_summa,ld_taskuup,ll_saajanr,ls_info,ls_alus,ll_tulnr;
    if sqlstate = err_notfound then -- kui eof
      leave dk_taitur_loop
    end if;
    if exists(select 1 from gl_dk_taitur where gl_dk_taitur."id"=ll_id and gl_dk_taitur.tulnr=ll_tulnr and gl_dk_taitur.saajanr=ll_saajanr) then
      update gl_dk_taitur set summa=summa+ldc_summa, alus=if locate(alus,ls_alus,1) = 0 then Trim(alus+' '+ls_alus) else alus endif, taskuup=if taskuup is null or ld_taskuup>taskuup then ld_taskuup else taskuup endif where gl_dk_taitur."id"=ll_id and gl_dk_taitur.tulnr=ll_tulnr and gl_dk_taitur.saajanr=ll_saajanr
    else
      insert into gl_dk_taitur ("id",arvekuup,arvenr,asutnr,taiturnr,saajanr,akuup,lkuup,summa,laekunud,"info",alus,taskuup,laekus,tulnr) values (ll_id,ld_arvekuup,ls_arvenr,ll_asutnr,ll_taiturnr,ll_saajanr,ld_akuup,ld_lkuup,ldc_summa,0,ls_info,ls_alus,ld_taskuup,'',ll_tulnr)
    end if
  end loop dk_taitur_loop;
  close c_dk_taitur;

  open c_gl_dk_taitur;
  gl_dk_taitur_loop: loop
    --  loe taituri kanne
    fetch next c_gl_dk_taitur into ll_id,ll_tulnr,ls_laekus,ldc_summa;
    if sqlstate = err_notfound then -- kui eof
      leave gl_dk_taitur_loop
    end if;
    update first gl_dk_taitur set laekunud=laekunud+ldc_summa, laekus=Left(Trim(laekus+' '+ls_laekus+';'),400) where gl_dk_taitur."id"=ll_id and gl_dk_taitur.tulnr=ll_tulnr
  end loop gl_dk_taitur_loop;
  close c_gl_dk_taitur;

  set li_id = 0;
  open c_gl_dk_jrknr;
  gl_dk_jrknr_loop: loop
    --  loe taituri kanne
    fetch next c_gl_dk_jrknr into ll_id,ll_jrknr;
    if sqlstate = err_notfound then -- kui eof
      leave gl_dk_jrknr_loop
    end if;
    if ll_jrknr is null then
      set li_id = li_id + 1;
      update gl_dk_taitur set jrknr=li_id where gl_dk_taitur."id"=ll_id
    end if
  end loop gl_dk_jrknr_loop;
  close c_gl_dk_jrknr;
END