ALTER PROCEDURE "dba"."dk_teatis_koond"(in a_id_komb integer default 1)
begin
  declare ll_objnr integer;
  declare ld_arvekuup date;
  declare ls_arvenr char(20);
  declare ll_asutnr integer;
  declare ld_peralg date;
  declare ld_perlop date;
  declare ld_kuup date;
  declare ld_laekuup date;
  declare ldc_summa decimal(15,2);
  declare ldc_volg decimal(15,2);
  declare ldc_arvest decimal(15,2);
  declare ldc_arve decimal(15,2);
  declare ldc_laekunud decimal(15,2);
  declare ls_dk_kontod char(5000);
  declare ll_skoop integer;
  declare li_teatis smallint;
  declare li_volg smallint;
  declare li_yksobj smallint;
  declare li_viivis smallint;
  declare err_notfound exception for sqlstate value '02000';
  declare c_tr_arve dynamic scroll cursor for select distinct gl_tr_arve.objnr,gl_tr_arve.arvekuup,gl_tr_arve.arvenr,gl_tr_arve.asutnr,gl_tr_arve.skoop from gl_tr_arve;
  declare c_dk_kanne dynamic scroll cursor for
    select if dk_kanne.sisse=1 then dk_kanne.summa+dk_kanne.summa2 else (-1)*(dk_kanne.summa+dk_kanne.summa2) endif,
           if li_volg = 1 then dk_kanne.kuup else dk_kanne.arvekuup endif
      from dk_kanne left outer join dk_obj on dk_kanne.objnr=dk_obj.objnr
      where dk_obj.skoop=ll_skoop and
           (dk_kanne.objnr=ll_objnr or (li_yksobj=0 and dk_obj.viivis=0)) and
            dk_kanne.asutnr=ll_asutnr and
            dk_kanne.arvekuup<=ld_arvekuup;
  select "dk_arve_komb"."teatis","dk_arve_komb"."volg","dk_arve_komb"."yksobj","dk_arve_komb"."viivis" into li_teatis,li_volg,li_yksobj,li_viivis from "dk_arve_komb" where "dk_arve_komb"."id"=a_id_komb;
  open c_tr_arve;
  tr_arve_loop: loop
    fetch next c_tr_arve into ll_objnr,ld_arvekuup,ls_arvenr,ll_asutnr,ll_skoop;
    if sqlstate = err_notfound then -- kui eof
      leave tr_arve_loop
    end if;
    if li_teatis = 0 then
      set ld_perlop=ld_arvekuup
    else
      set ld_perlop=dateadd(month,-1,ld_arvekuup);
      set ld_perlop=get_perlop(ld_perlop)
    end if;
    set ld_peralg=get_peralg(ld_perlop);
    set ldc_summa=0;
    set ldc_volg=0;
    set ldc_arvest=0;
    set ldc_arve=0;
    set ldc_laekunud=0;
    set ld_laekuup=ld_peralg;
    open c_dk_kanne;
    dk_kanne_loop: loop
      fetch next c_dk_kanne into ldc_summa,ld_kuup;
      if sqlstate = err_notfound then -- kui eof
        leave dk_kanne_loop
      end if;
      if ld_kuup < ld_peralg then
        set ldc_volg=ldc_volg+ldc_summa
      elseif ld_kuup > ld_perlop then
        set ldc_arve=ldc_arve+ldc_summa
      else
        set ldc_arvest=ldc_arvest+ldc_summa
      end if
    end loop dk_kanne_loop;
    close c_dk_kanne;
    -- laekumine
    set ls_dk_kontod=get_dk_kontod_spank(ll_skoop,2,(if li_yksobj=1 then ll_objnr else 0 endif),0);
    select sum(if kp_kanne.kuup < ld_peralg then if kp_kanne.sisse = 1 then kp_kanne.summa else (-1)*kp_kanne.summa endif else 0 endif),
           sum(if kp_kanne.kuup >= ld_peralg then if kp_kanne.sisse = 1 then kp_kanne.summa else (-1)*kp_kanne.summa endif else 0 endif),
           max(kp_kanne.kuup)
      into ldc_summa,ldc_laekunud,ld_laekuup
      from kp_kanne left outer join kp_obj on kp_kanne.objnr = kp_obj.objnr
      where kp_kanne.asutnr = ll_asutnr and
            kp_obj.skoop = ll_skoop and
            locate(ls_dk_kontod,';'+"Left"(kp_kanne.konto+Space(7),7)+';') > 0 and
            kp_kanne.kuup<=ld_arvekuup;
    if ldc_summa is null then
      set ldc_summa=0
    end if;
    if ldc_laekunud is null then
      set ldc_laekunud=0
    end if;
    set ldc_volg=ldc_volg-ldc_summa;
    update gl_tr_arve set gl_tr_arve.volg=ldc_volg,gl_tr_arve.arvest=ldc_arvest,gl_tr_arve.arve=ldc_arve,gl_tr_arve.laekunud=ldc_laekunud,gl_tr_arve.laekuup=ld_laekuup,gl_tr_arve.peralg=ld_peralg,gl_tr_arve.perlop=ld_perlop where gl_tr_arve.objnr=ll_objnr and gl_tr_arve.arvekuup=ld_arvekuup and gl_tr_arve.arvenr=ls_arvenr and gl_tr_arve.asutnr=ll_asutnr;
    -- viivis
    if li_viivis=1 then
      set ldc_summa=0;
      set ldc_volg=0;
      set ldc_arvest=0;
      set ldc_arve=0;
      set ldc_laekunud=0;
      set ld_laekuup=ld_peralg;
      if li_volg=1 then
        select sum(if dk_kanne.kuup<ld_peralg then if dk_kanne.sisse=1 then dk_kanne.summa+dk_kanne.summa2 else (-1)*(dk_kanne.summa+dk_kanne.summa2) endif else 0 endif),
               sum(if dk_kanne.kuup>=ld_peralg then if dk_kanne.sisse=1 then dk_kanne.summa+dk_kanne.summa2 else (-1)*(dk_kanne.summa+dk_kanne.summa2) endif else 0 endif)
        into ldc_volg,ldc_arvest
        from dk_kanne left outer join dk_obj on dk_kanne.objnr=dk_obj.objnr
        where dk_obj.skoop=ll_skoop and
              dk_obj.viivis=1 and
              dk_kanne.asutnr=ll_asutnr and
              dk_kanne.arvekuup<=ld_arvekuup;
      else
        select sum(if dk_kanne.arvekuup<ld_peralg then if dk_kanne.sisse=1 then dk_kanne.summa+dk_kanne.summa2 else (-1)*(dk_kanne.summa+dk_kanne.summa2) endif else 0 endif),
               sum(if dk_kanne.arvekuup>=ld_peralg then if dk_kanne.sisse=1 then dk_kanne.summa+dk_kanne.summa2 else (-1)*(dk_kanne.summa+dk_kanne.summa2) endif else 0 endif)
        into ldc_volg,ldc_arvest
        from dk_kanne left outer join dk_obj on dk_kanne.objnr=dk_obj.objnr
        where dk_obj.skoop=ll_skoop and
              dk_obj.viivis=1 and
              dk_kanne.asutnr=ll_asutnr and
              dk_kanne.arvekuup<=ld_arvekuup;
      end if;
      if ldc_volg is null then
        set ldc_volg=0
      end if;
      if ldc_arvest is null then
        set ldc_arvest=0
      end if;
      -- viivise laekumine
      set ls_dk_kontod=get_dk_kontod_spank(ll_skoop,2,(if li_yksobj=1 then ll_objnr else 0 endif),1);
      select sum(if kp_kanne.kuup < ld_peralg then if kp_kanne.sisse = 1 then kp_kanne.summa else (-1)*kp_kanne.summa endif else 0 endif),
             sum(if kp_kanne.kuup >= ld_peralg then if kp_kanne.sisse = 1 then kp_kanne.summa else (-1)*kp_kanne.summa endif else 0 endif),
             max(kp_kanne.kuup)
        into ldc_summa,ldc_laekunud,ld_laekuup
        from kp_kanne left outer join kp_obj on kp_kanne.objnr = kp_obj.objnr
        where kp_kanne.asutnr = ll_asutnr and
              kp_obj.skoop = ll_skoop and
              locate(ls_dk_kontod,';'+"Left"(kp_kanne.konto+Space(7),7)+';') > 0 and
              kp_kanne.kuup<=ld_arvekuup;
      if ldc_summa is null then
        set ldc_summa=0
      end if;
      if ldc_laekunud is null then
        set ldc_laekunud=0
      end if;
      set ldc_volg=ldc_volg-ldc_summa;
      update gl_tr_arve set gl_tr_arve.volg_viivis=ldc_volg,gl_tr_arve.arvest_viivis=ldc_arvest,gl_tr_arve.laekunud=gl_tr_arve.laekunud+ldc_laekunud,gl_tr_arve.laekuup=if ld_laekuup>gl_tr_arve.laekuup then ld_laekuup else gl_tr_arve.laekuup endif where gl_tr_arve.objnr=ll_objnr and gl_tr_arve.arvekuup=ld_arvekuup and gl_tr_arve.arvenr=ls_arvenr and gl_tr_arve.asutnr=ll_asutnr;
    end if;
  end loop tr_arve_loop;
  close c_tr_arve
end