CREATE PROCEDURE "DBA"."ea_kanne_org"( in a_skoop integer, in a_orgnr integer, in a_peralg date default ToDay(), in a_perlop date default ToDay() )
RESULT( "id" integer, aasta integer, kuup date, doknr char(10), summa numeric(15,2), "info" char(351), meetlist char(117), kullist char(117), tallist char(117), artlist char(117), tullist char(117), objlist char(117), osaklist char(117), sublist char(117), suundlist char(117), taotlist char(117), taiendus char(250), tulnud char(100))
BEGIN
  declare ll_objnr integer;
  declare ll_kulnr integer;
  declare ll_talnr integer;
  declare ll_objectnr integer;
  declare ll_osaknr integer;
  select if ea_objnr is null then 0 else ea_objnr endif,if kulnr is null then 0 else kulnr endif,if talnr is null then 0 else talnr endif,if objectnr is null then 0 else objectnr endif,if osaknr is null then 0 else osaknr endif into ll_objnr,ll_kulnr,ll_talnr,ll_objectnr,ll_osaknr from orglist where orgnr=a_orgnr;
    select ea_kanne."id",
           ea_kanne.aasta,
           ea_kanne.kuup,
           ea_kanne.doknr,
           ea_kanne.summa,
           LTrim(ea_alus.nimi+' ')+ea_kanne."info",
           Trim(meetlist.meet)+' '+meetlist.nimi,
           Trim(kullist.ptk)+' '+kullist.nimi,
           Trim(tallist.osa)+' '+tallist.nimi,
           Trim(artlist.art)+' '+artlist.nimi,
           Trim(tullist.osa)+' '+tullist.nimi,
           Trim(objlist."object")+' '+objlist.nimi,
           Trim(osaklist.osak)+' '+osaklist.nimi,
           Trim(sublist.subject)+' '+sublist.nimi,
           Trim(suundlist.suund)+' '+suundlist.nimi,
           Trim(taotlist.taot)+' '+taotlist.nimi,
           ea_kanne.taiendus,
           ea_kanne.tulnud
      from ea_kanne left outer join ea_obj on ea_kanne.objnr = ea_obj.objnr
                    left outer join ea_alus on ea_kanne.alusnr = ea_alus.alusnr
                    left outer join meetlist on ea_kanne.meetnr = meetlist.meetnr
                    left outer join kullist on ea_kanne.kulnr = kullist.kulnr
                    left outer join tallist on ea_kanne.talnr = tallist.talnr
                    left outer join artlist on ea_kanne.artnr = artlist.artnr
                    left outer join tullist on ea_kanne.tulnr = tullist.tulnr
                    left outer join objlist on ea_kanne.objectnr = objlist.objectnr
                    left outer join osaklist on ea_kanne.osaknr = osaklist.osaknr
                    left outer join sublist on ea_kanne.subjectnr = sublist.subjectnr
                    left outer join suundlist on ea_kanne.suundnr = suundlist.suundnr
                    left outer join taotlist on ea_kanne.taotnr = taotlist.taotnr
      where (ea_obj.skoop = a_skoop or a_skoop = 0) and
             ea_kanne.objnr=ll_objnr and
            (ea_kanne.kulnr=ll_kulnr or ll_kulnr=0) and
            (ea_kanne.talnr=ll_talnr or ll_talnr=0) and
            (ea_kanne.objectnr=ll_objectnr or ll_objectnr=0) and
            (ea_kanne.osaknr=ll_osaknr or ll_osaknr=0) and
            (ea_kanne.kuup>=a_peralg) and (ea_kanne.kuup<=a_perlop);
END