CREATE PROCEDURE "dba"."ea_tulkul_veera"( in a_aasta numeric(4) default 2018, in a_skoop integer default 0 )
RESULT( id_kanne integer, aasta integer, tulnud char(100), doknr char(20), kuup date, summa decimal(15,2), "info" char(300), meede char(16), kuluobjekt char(16), tegevusala char(16), kululiik char(16), tululiik char(16), projekt char(16), osakond char(16), subjekt char(16), tegevussuund char(16), taotlus char(16), kell timestamp, kell2 timestamp )
BEGIN
  
  if a_skoop is null then
    set a_skoop=0
  end if;
  -- koond
  select ea_kanne."id",ea_kanne.aasta,ea_kanne.tulnud,ea_kanne.doknr,ea_kanne.kuup,ea_kanne.summa,csconvert(trim(ea_alus.nimi+' '+ea_kanne."info"),'UTF-8'),meetlist.meet,kullist.ptk,tallist.osa,artlist.art,tullist.osa,objlist."object",osaklist.osak,sublist.subject,suundlist.suund,taotlist.taot,ea_kanne.kell,ea_kanne.kell2
    from ea_kanne left outer join meetlist on ea_kanne.meetnr=meetlist.meetnr
                     left outer join kullist on ea_kanne.kulnr=kullist.kulnr
                     left outer join tallist on ea_kanne.talnr=tallist.talnr
                     left outer join artlist on ea_kanne.artnr=artlist.artnr
                     left outer join tullist on ea_kanne.tulnr=tullist.tulnr
                     left outer join objlist on ea_kanne.objectnr=objlist.objectnr
                     left outer join osaklist on ea_kanne.osaknr=osaklist.osaknr
                     left outer join sublist on ea_kanne.subjectnr=sublist.subjectnr
                     left outer join suundlist on ea_kanne.suundnr=suundlist.suundnr
                     left outer join taotlist on ea_kanne.taotnr=taotlist.taotnr
                     left outer join ea_alus on ea_kanne.alusnr=ea_alus.alusnr
                     left outer join ea_obj on ea_kanne.objnr=ea_obj.objnr
     where ea_kanne.aasta=a_aasta and (ea_obj.skoop=a_skoop or a_skoop=0);
                    
END