ALTER FUNCTION "DBA"."existid_kblist_nimi"( in a_nimi char(25) )
returns integer
begin
  declare ll_kbnr integer;
  declare ll_nimi integer;
  declare ls_productversion char(100);
  select first kblist.kbnr into ll_kbnr from kblist where kblist.nimi = a_nimi order by kblist.nimi asc,kblist.vaikimisi desc;
  if ll_kbnr = 0 or ll_kbnr is null then
    select property('ProductVersion') into ls_productversion from DUMMY;
    if not left(ls_productversion,1) in ('7','8') then
      if isnumeric(a_nimi)=1 then
        set ll_nimi=convert(integer, convert(decimal,a_nimi));
        select kblist.kbnr into ll_kbnr from kblist where kblist.kbnr = ll_nimi;
      end if
    end if;
  end if;
  if ll_kbnr=0 then
    set ll_kbnr=null
  end if;
  return(ll_kbnr)
end