ALTER FUNCTION "DBA"."get_eak_asutnr"( in a_regnr char(11),in a_nimi char(50),in a_sellercode char(50))
RETURNS INTEGER
BEGIN
  declare ll_asutnr integer;
  declare ls_productversion char(100);
  if a_sellercode is null or length(trim(a_sellercode))=0 then
    set ll_asutnr=0;
  else
    set a_sellercode=Left(Trim(a_sellercode),9);
    select property('ProductVersion') into ls_productversion from DUMMY;
    if left(ls_productversion,1) in ('7','8') then
      set ll_asutnr=0;
    else
      if isnumeric(a_sellercode)=1 then
        set ll_asutnr=convert(integer,a_sellercode);
      else
        set ll_asutnr=0
      end if;
    end if;
    if ll_asutnr is null then
      set ll_asutnr=0
    end if;
    if ll_asutnr>0 then
      if Length(Trim(a_regnr))>0 then
        if not exists( select 1 from asulist where asutnr=ll_asutnr and reg_nr=a_regnr) then
          set ll_asutnr=0
        end if
      else
        set ll_asutnr=0
      end if;
    end if
  end if;
  if ll_asutnr=0 or ll_asutnr is null then
    set ll_asutnr=existid_asulist(a_regnr,a_nimi,'','')
  end if;
  return ll_asutnr;
END