ALTER FUNCTION "dba"."get_pens_tunnus"( in a_asutnr integer, in a_aasta integer, in a_akuu integer)
returns integer
begin
  declare li_pens integer;
  declare ls_iskood char(11);
  declare ls_aasta char(4);
  declare li_aasta integer;
  declare ld_kuup date;
  declare ld_penskuup date;
  declare ld_penskuup2 date;
  set ld_kuup=ymd(a_aasta,a_akuu,2);
  set li_pens=0;
  select if pa_kaader.penskuup is null then ymd(2999,1,1) else pa_kaader.penskuup endif,
         if pa_kaader.penskuup2 is null then ymd(2999,1,1) else pa_kaader.penskuup2 endif
    into ld_penskuup,ld_penskuup2
    from pa_kaader where pa_kaader.asutnr=a_asutnr;
  -- kui lopetatud hiljem, siis jatka, muidu tunnus 0 ja ei arvutata
  if ld_kuup<ld_penskuup2 then
    -- kui alustatud varem, siis arvuta, muidu kontrolli vanuse jrgi
    if ld_kuup>ld_penskuup then
      set li_pens=1
    else
      -- kontrolli ainult kui alguse kuupaev ei ole sisestatud
      if ld_penskuup=ymd(2999,1,1) then
        select trim(reg_nr) into ls_iskood from asulist where asutnr=a_asutnr;
        case "Left"(ls_iskood,1) when '1' then
          set ls_aasta='18' when '2' then
          set ls_aasta='18' when '3' then
          set ls_aasta='19' when '4' then
          set ls_aasta='19' when '5' then
          set ls_aasta='20' when '6' then
          set ls_aasta='20' when '7' then
          set ls_aasta='21' when '8' then
          set ls_aasta='21'
        else
          set ls_aasta='19'
        end case
        ;
        set temporary option CONVERSION_ERROR = 'OFF';
        set li_aasta=convert(integer,ls_aasta+substring(ls_iskood,2,2));
        set temporary option CONVERSION_ERROR = 'ON';
        if li_aasta is null or li_aasta < 1800 or li_aasta > 2999 then
          set li_aasta=1900
        end if;
        if li_aasta>1982 and a_aasta-li_aasta>18 then
          set li_pens=1
        end if;
      end if;
    end if;
  end if;
  return li_pens;
end