CREATE FUNCTION "DBA"."get_xml_value"( a_field long varchar, a_row long varchar)
RETURNS long varchar
BEGIN
  declare ls_value long varchar;
  declare ll_pos1 integer;
  declare ll_pos2 integer;
  set ll_pos1=locate(a_row,'<'+a_field+'>',1);
  if ll_pos1>0 then
    set ll_pos2=locate(a_row,'</'+a_field+'>',ll_pos1);
    if ll_pos2>ll_pos1 then
      set ls_value=substring(a_row,ll_pos1+Length(a_field)+2, ll_pos2-ll_pos1-Length(a_field)-2);
      set ls_value=trim(ls_value);
    end if;
  end if;
  if ls_value is null then
    set ls_value=''
  end if;
  RETURN ls_value;
END