ALTER PROCEDURE "dba"."pa_arvuta2018"(in a_lepnr integer,in li_t_aasta integer, li_t_akuu integer)
begin
  -- varasem maksustatav summa
  declare ldc_tulu_summa2 numeric(15,2);
  declare ldc_tvtk_summa2 numeric(15,2);
  declare ldc_pens_summa2 numeric(15,2);
  declare ldc_tatk_summa2 numeric(15,2);
  -- maksustatav summa
  declare ldc_tulu_summa3 numeric(15,2);
  declare ldc_tvtk_summa3 numeric(15,2);
  declare ldc_pens_summa3 numeric(15,2);
  declare ldc_tatk_summa3 numeric(15,2);
  -- varasem maks
  declare ldc_maksuvaba2 numeric(15,2);
  declare ldc_tulu_maks2 numeric(15,2);
  declare ldc_tvtk_maks2 numeric(15,2);
  declare ldc_pens_maks2 numeric(15,2);
  declare ldc_tatk_maks2 numeric(15,2);
  -- jagamiseks maksuvaba
  declare ldc_jaga_maksuvaba3 numeric(15,2);
  -- kasutatud maksuvaba
  declare ldc_maksuvaba3 numeric(15,2);
  declare ldc_maksuvaba3_630 numeric(15,2);
  -- maks
  declare ldc_tulu_maks3 numeric(15,2);
  declare ldc_tvtk_maks3 numeric(15,2);
  declare ldc_pens_maks3 numeric(15,2);
  declare ldc_tatk_maks3 numeric(15,2);
  -- jooksva rea maks
  declare ldc_tulu_maks4 numeric(15,2);
  declare ldc_tvtk_maks4 numeric(15,2);
  declare ldc_pens_maks4 numeric(15,2);
  declare ldc_tatk_maks4 numeric(15,2);
  -- maksu proportsioon
  declare ldc_tulu_prop numeric(15,6);
  declare ldc_tvtk_prop numeric(15,6);
  declare ldc_pens_prop numeric(15,6);
  declare ldc_tatk_prop numeric(15,6);
  -- viimane arvutatav rida
  declare li_last_tulu_tasunr integer;
  declare li_last_tulu_a_aasta integer;
  declare li_last_tulu_sisse smallint;
  declare li_last_tvtk_tasunr integer;
  declare li_last_tvtk_a_aasta integer;
  declare li_last_tvtk_sisse smallint;
  declare li_last_pens_tasunr integer;
  declare li_last_pens_a_aasta integer;
  declare li_last_pens_sisse smallint;
  declare li_last_tatk_tasunr integer;
  declare li_last_tatk_a_aasta integer;
  declare li_last_tatk_sisse smallint;
-- maarad
  declare ldc_tulu_vaba numeric(10,3);
  declare ldc_tulu_vaba_maar numeric(10,3);
  declare ldc_tulu_vaba_oigus numeric(10,3);
  declare ldc_tulu_protsent numeric(10,3);
  declare ldc_tulu_protsent_erand numeric(10,3);
  declare ldc_tulu_protsent_arvuta numeric(10,3);
  declare ldc_tvtk_protsent numeric(10,3);
  declare ldc_pens_protsent numeric(10,3);
  declare ldc_pens_rate numeric(10,3);
  declare ldc_tatk_protsent numeric(10,3);
  -- arvutatava rea fetch
  declare li_m_aasta integer;
  declare li_m_akuu integer;
  -- perioodist soltuvad
  declare li_tmt smallint;
  declare ldc_mvaba numeric(10,3);
  declare li_pens smallint;
  declare li_tk smallint;
  declare li_penskar smallint;
  -- arvutatava rea fetch
  declare li_tasunr integer;
  declare li_a_aasta integer;
  declare ldc_summa3 numeric(15,2);
  declare li_sisse smallint;
  declare li_tulu smallint;
  declare li_tvtk smallint;
  declare li_tasu_pens smallint;
  declare li_tatk smallint;
  declare li_asutnr integer;
  declare li_mres smallint;
  declare ls_vmkood char(3);
  declare ls_skoopkood char(16);
  declare ld_perlop date;
  declare err_notfound exception for sqlstate value '02000';
  -- Dekl 01 Maks NULL muuta saab ridu, mis sama leping, ei ole palgalehes, ei ole tagasiarvestus
  declare c_tasu insensitive cursor for
    select pa_tasu.tasunr,pa_tasu.a_aasta,pa_tasu.summa,pa_taslist.sisse,pa_taslist.tulu,if pa_taslist.tk=1 and li_tk=1 then 1 else 0 endif,if pa_taslist.pens=1 and li_pens>0 then 1 else 0 endif,pa_taslist.tatk
      from pa_tasu left outer join pa_taslist on pa_tasu.tas_s = pa_taslist.tas_s left outer join pa_taslist as pa_taslist_b on pa_tasu.vtas_s = pa_taslist_b.tas_s
      where pa_tasu.lepnr=a_lepnr and pa_tasu.palgaleht is null and pa_tasu.vtasunr is null and pa_tasu.t_aasta=li_t_aasta and pa_tasu.t_akuu=li_t_akuu and if pa_taslist.vmkood is null then pa_taslist_b.vmkood else pa_taslist.vmkood endif=ls_vmkood;
  declare c_vmkood insensitive cursor for
    select distinct pa_taslist.vmkood
      from pa_tasu left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where pa_tasu.lepnr=a_lepnr and pa_tasu.t_aasta=li_t_aasta and pa_tasu.t_akuu=li_t_akuu and pa_tasu.palgaleht is null and pa_taslist.vmkood is not null
      order by pa_taslist.vmkood asc;
  declare c_maksper insensitive cursor for
    select distinct pa_tasu_b.t_aasta,pa_tasu_b.t_akuu
      from pa_tasu left outer join pa_tasu as pa_tasu_b on pa_tasu.vtasunr=pa_tasu_b.tasunr and pa_tasu.va_aasta=pa_tasu_b.a_aasta
      where pa_tasu.lepnr=a_lepnr and pa_tasu.palgaleht is null and pa_tasu.vtasunr is not null and pa_tasu.t_aasta=li_t_aasta and pa_tasu.t_akuu=li_t_akuu;
  -- Dekl 01 Maks 12 muuta saab tagasiarvestuse ridu
  declare c_makstasu insensitive cursor for
    select pa_tasu.tasunr,pa_tasu.a_aasta,pa_tasu.summa,pa_taslist.sisse,pa_taslist.tulu,if pa_taslist.tk=1 and li_tk=1 then 1 else 0 endif,if pa_taslist.pens=1 and li_pens>0 then 1 else 0 endif,pa_taslist.tatk
      from pa_tasu left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s left outer join pa_taslist as pa_taslist_b on pa_tasu.vtas_s = pa_taslist_b.tas_s left outer join pa_tasu as pa_tasu_b on pa_tasu.vtasunr=pa_tasu_b.tasunr and pa_tasu.va_aasta=pa_tasu_b.a_aasta
      where pa_tasu.lepnr=a_lepnr and pa_tasu.palgaleht is null and pa_tasu.vtasunr is not null and pa_tasu.t_aasta=li_t_aasta and pa_tasu.t_akuu=li_t_akuu and pa_tasu_b.t_aasta=li_m_aasta and pa_tasu_b.t_akuu=li_m_akuu and if pa_taslist.vmkood is null then pa_taslist_b.vmkood else pa_taslist.vmkood endif=ls_vmkood;
  declare c_maksvmkood insensitive cursor for
    select distinct pa_taslist.vmkood
      from pa_tasu left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s left outer join pa_tasu as pa_tasu_b on pa_tasu.vtasunr=pa_tasu_b.tasunr and pa_tasu.va_aasta=pa_tasu_b.a_aasta
      where pa_tasu.lepnr=a_lepnr and pa_tasu.t_aasta=li_t_aasta and pa_tasu.t_akuu=li_t_akuu and pa_tasu.palgaleht is null and pa_taslist.vmkood is not null and pa_tasu_b.t_aasta=li_m_aasta and pa_tasu_b.t_akuu=li_m_akuu
     order by pa_taslist.vmkood asc;
  -- algandmed
  select yld_maksud_skoop into li_sisse from pa_konfm where id=1;
  select pa_leping.asutnr,if li_sisse is null or li_sisse=0 or skoobid.kood is null then '' else skoobid.kood endif into li_asutnr,ls_skoopkood from pa_leping left outer join skoobid on pa_leping.skoop=skoobid.skoop where pa_leping.lepnr = a_lepnr;
  select if pa_kaader.mres is null then 0 else pa_kaader.mres endif into li_mres from pa_kaader where pa_kaader.asutnr=li_asutnr;
  set ld_perlop=ymd(li_t_aasta,li_t_akuu,1);
    -- yldised maarad
    set li_penskar=get_penskar(li_asutnr,li_t_aasta);
    if li_penskar=1 then
      set ldc_tulu_vaba_maar=get_maar(15,ld_perlop);
    else
      set ldc_tulu_vaba_maar=get_maar(1,ld_perlop);
    end if;
    set ldc_tulu_protsent=get_maar(2,ld_perlop);
    set ldc_tulu_protsent_erand=10;
    set ldc_tvtk_protsent=get_maar(3,ld_perlop);
    set ldc_pens_protsent=get_maar(4,ld_perlop);
    set ldc_tatk_protsent=get_maar(5,ld_perlop);
    -- tulumaks
    set li_tmt=get_pa_kaader_tun_tmt(li_asutnr,ld_perlop,ls_skoopkood);
    if li_tmt=0 then
      set ldc_tulu_vaba=0;
      set ldc_tulu_protsent=0;
      set ldc_tulu_protsent_erand=0
    else
      if li_tmt=2 then
        set ldc_tulu_vaba=0
      else
        set ldc_mvaba=get_pa_kaader_tun_mvaba(li_asutnr,ld_perlop,ls_skoopkood);
        if ldc_mvaba>0 and ldc_mvaba<ldc_tulu_vaba_maar then
          set ldc_tulu_vaba=ldc_mvaba
        else
          set ldc_tulu_vaba=ldc_tulu_vaba_maar
        end if
      end if
    end if;
    -- tootuskindlustus
    set li_tk=get_pa_kaader_tun_tk(li_asutnr,ld_perlop,ls_skoopkood);
    if li_tk>1 then
      set li_tk=get_tk_tunnus(li_asutnr,li_t_aasta,li_t_akuu)
    end if;
    -- pensionikindlustus
    set li_pens=get_pens_tunnus(li_asutnr,li_t_aasta,li_t_akuu);
    if li_pens=1 then
      set ldc_pens_rate=get_pa_kaader_pens_rate(li_asutnr,ld_perlop);
      if ldc_pens_rate>0 then
        set ldc_pens_protsent=ldc_pens_rate
      end if
    else
      set ldc_pens_protsent=0
    end if;
    -- kustuta toolepingu varasemad arvutatavad summad, mis ei ole palgalehega kinnipeetud
    delete from pa_tasu from pa_tasu left outer join pa_taslist on pa_tasu.tas_s = pa_taslist.tas_s where pa_tasu.lepnr = a_lepnr and pa_tasu.t_akuu = li_t_akuu and pa_tasu.t_aasta = li_t_aasta and pa_tasu.palgaleht is null and (pa_taslist.algol = '8o' or pa_taslist.algol = '3b' or pa_taslist.algol = '5a' or pa_taslist.algol = '5c' or pa_taslist.algol = '6a' or pa_taslist.algol = '8c' );
    -- Dekl 01 nullitakse pea ja alam arvutuste read
    update pa_tasu set maksuvaba=0,tulumaks=0,tvtkmaks=0,pensmaks=0,tatkmaks=0,sotsmaks=0 where pa_tasu.lepnr=a_lepnr and pa_tasu.t_akuu=li_t_akuu and pa_tasu.t_aasta=li_t_aasta and pa_tasu.palgaleht is null;
    update pa_tasu left outer join pa_leping on pa_tasu.lepnr = pa_leping.lepnr left outer join skoobid on pa_leping.skoop=skoobid.skoop set sotsmaks = 0 where pa_leping.asutnr=li_asutnr and pa_tasu.t_akuu=li_t_akuu and pa_tasu.t_aasta=li_t_aasta and pa_tasu.palgaleht is null and skoobid.kood=ls_skoopkood;
    -- kinnipidamised enne tulumaksu
    call pa_kinnip('5a',a_lepnr,li_t_akuu,li_t_aasta);
    call pa_kinnip('5c',a_lepnr,li_t_akuu,li_t_aasta);
    call pa_kinnip('6a',a_lepnr,li_t_akuu,li_t_aasta);
    call pa_kinnip_III_sammas(a_lepnr,li_t_akuu,li_t_aasta);
    -- sotsiaalmaksu arvutamine
    call pa_arvuta2018_sots(a_lepnr,li_asutnr,li_t_akuu,li_t_aasta,ls_skoopkood);
    -- kasutatud maksuvaba ja maksustatav summa
    select sum(((-2)*pa_taslist.sisse+1)*pa_tasu.maksuvaba),
           sum(if pa_taslist.tulu=1 then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif)
      into ldc_maksuvaba2,ldc_tulu_summa2
      from pa_tasu left outer join pa_leping on pa_tasu.lepnr = pa_leping.lepnr
                   left outer join pa_taslist on pa_tasu.tas_s = pa_taslist.tas_s
                   left outer join pa_tasu as pa_tasu_b on pa_tasu.vtasunr=pa_tasu_b.tasunr and pa_tasu.va_aasta=pa_tasu_b.a_aasta
                   left outer join skoobid on pa_leping.skoop=skoobid.skoop
      where pa_leping.asutnr=li_asutnr and ((pa_tasu.vtasunr is null and pa_tasu.t_aasta=li_t_aasta and pa_tasu.t_akuu=li_t_akuu) or (pa_tasu.vtasunr is not null and pa_tasu_b.t_aasta=li_t_aasta and pa_tasu_b.t_akuu=li_t_akuu)) and skoobid.kood=ls_skoopkood;
    if ldc_maksuvaba2 is null then
      set ldc_maksuvaba2=0
    end if;
    if ldc_tulu_summa2 is null then
      set ldc_tulu_summa2=0
    end if;
    -- oigus kasutada maksuvaba kuni aastani 2026 valjaarvatud
    if li_penskar=0 and li_t_aasta<2026 then
      set ldc_tulu_vaba_oigus=Round(ldc_tulu_vaba_maar-((ldc_tulu_vaba_maar/900)*(ldc_tulu_summa2-1200)),2);
      if ldc_tulu_vaba_oigus>ldc_tulu_vaba_maar then
        set ldc_tulu_vaba_oigus=ldc_tulu_vaba_maar
      end if;
      if ldc_tulu_vaba_oigus<0 then
        set ldc_tulu_vaba_oigus=0
      end if;
      if ldc_tulu_vaba>ldc_tulu_vaba_oigus then
        set ldc_tulu_vaba=ldc_tulu_vaba_oigus
      end if;
    end if;
    -- kuu kasutamata maksuvaba
    set ldc_jaga_maksuvaba3=ldc_tulu_vaba-ldc_maksuvaba2;
    -- valjamakseliikide loikes
    open c_vmkood;
    vmkood_loop: loop
      fetch next c_vmkood into ls_vmkood;
      if sqlstate = err_notfound then
        leave vmkood_loop
      end if;
      if ls_vmkood in ('46','150','151','152','153','168','170','180','182','183','184','187','188','189','190','191','192','193','194','195') then
        set ldc_tulu_protsent_arvuta=ldc_tulu_protsent_erand
      else
        set ldc_tulu_protsent_arvuta=ldc_tulu_protsent
      end if;
      -- lisa maksuvaba, kui vmkood='25'
      if ls_vmkood='25' then
        -- tulumaksuga maksustatud summa, millest 15% maksuvaba
        set ldc_summa3=0;
        select sum(((-2)*pa_taslist.sisse+1)*pa_tasu.summa)
          into ldc_summa3
          from pa_tasu left outer join pa_leping on pa_tasu.lepnr = pa_leping.lepnr
                       left outer join pa_taslist as pa_taslist on pa_tasu.tas_s = pa_taslist.tas_s
                       left outer join pa_tasu as pa_tasu_b on pa_tasu.vtasunr=pa_tasu_b.tasunr and pa_tasu.va_aasta=pa_tasu_b.a_aasta
                       left outer join skoobid on pa_leping.skoop=skoobid.skoop
          where pa_leping.asutnr=li_asutnr and pa_taslist.tulu=1 and
              ((pa_tasu.vtasunr is null and pa_tasu.t_aasta=li_t_aasta and pa_tasu.t_akuu<=li_t_akuu) or (pa_tasu.vtasunr is not null and pa_tasu_b.t_aasta=li_t_aasta and pa_tasu_b.t_akuu<=li_t_akuu)) and
                skoobid.kood=ls_skoopkood;
        if ldc_summa3 is null then
          set ldc_maksuvaba3_630=0
        else
          set ldc_maksuvaba3_630=Round(ldc_summa3*0.15,2)
        end if;
        -- varem arvestatud III sammas, mis vhendab maksuvaba
        set ldc_summa3=0;
        select sum(if (pa_tasu.palgaleht is not null or pa_tasu.lepnr<>a_lepnr or pa_tasu.vtasunr is not null) then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif)
          into ldc_summa3
          from pa_tasu left outer join pa_leping on pa_tasu.lepnr = pa_leping.lepnr
                       left outer join pa_taslist as pa_taslist on pa_tasu.tas_s = pa_taslist.tas_s
                       left outer join pa_taslist as pa_taslist_b on pa_tasu.vtas_s = pa_taslist_b.tas_s
                       left outer join pa_tasu as pa_tasu_b on pa_tasu.vtasunr=pa_tasu_b.tasunr and pa_tasu.va_aasta=pa_tasu_b.a_aasta
                       left outer join skoobid on pa_leping.skoop=skoobid.skoop
          where pa_leping.asutnr=li_asutnr and
                if pa_taslist.vmkood is null then pa_taslist_b.vmkood else pa_taslist.vmkood endif='25' and
              ((pa_tasu.vtasunr is null and pa_tasu.t_aasta=li_t_aasta and pa_tasu.t_akuu<=li_t_akuu) or (pa_tasu.vtasunr is not null and pa_tasu_b.t_aasta=li_t_aasta and pa_tasu_b.t_akuu<=li_t_akuu)) and
                skoobid.kood=ls_skoopkood;
          if ldc_summa3<>0 then
            set ldc_maksuvaba3_630=ldc_maksuvaba3_630-ldc_summa3;
            if ldc_maksuvaba3_630<0 then
              set ldc_maksuvaba3_630=0
            end if;
          end if;
      else
        set ldc_maksuvaba3_630=0
      end if;
      -- kuu varasem maks, varasem maksustatav summa ja kinnipidamata maksustatav summa
      -- Dekl 01 voi Maks 01
      select sum(((-2)*pa_taslist.sisse+1)*pa_tasu.maksuvaba),
             sum(((-2)*pa_taslist.sisse+1)*pa_tasu.tulumaks),
             sum(((-2)*pa_taslist.sisse+1)*pa_tasu.tvtkmaks),
             sum(((-2)*pa_taslist.sisse+1)*pa_tasu.pensmaks),
             sum(((-2)*pa_taslist.sisse+1)*pa_tasu.tatkmaks),
             -- kui on palgalehes voi teine leping voi tagasiarvestus
             sum(if pa_taslist.tulu=1 and (pa_tasu.palgaleht is not null or pa_tasu.lepnr<>a_lepnr or pa_tasu.vtasunr is not null) then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif),
             sum(if pa_taslist.tk=1 and li_tk=1 and (pa_tasu.palgaleht is not null or pa_tasu.lepnr<>a_lepnr or pa_tasu.vtasunr is not null) then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif),
             sum(if pa_taslist.pens=1 and li_pens>0 and (pa_tasu.palgaleht is not null or pa_tasu.lepnr<>a_lepnr or pa_tasu.vtasunr is not null) then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif),
             sum(if pa_taslist.tatk=1 and (pa_tasu.palgaleht is not null or pa_tasu.lepnr<>a_lepnr or pa_tasu.vtasunr is not null) then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif),
             -- kui ei ole palgalehes ja ei ole tagasiarvestus
             sum(if pa_taslist.tulu=1 and pa_tasu.palgaleht is null and pa_tasu.lepnr=a_lepnr and pa_tasu.vtasunr is null then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif),
             sum(if pa_taslist.tk=1 and li_tk=1 and pa_tasu.palgaleht is null and pa_tasu.lepnr=a_lepnr and pa_tasu.vtasunr is null then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif),
             sum(if pa_taslist.pens=1 and li_pens>0 and pa_tasu.palgaleht is null and pa_tasu.lepnr=a_lepnr and pa_tasu.vtasunr is null then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif),
             sum(if pa_taslist.tatk=1 and pa_tasu.palgaleht is null and pa_tasu.lepnr=a_lepnr and pa_tasu.vtasunr is null then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif)
        into ldc_maksuvaba2,ldc_tulu_maks2,ldc_tvtk_maks2,ldc_pens_maks2,ldc_tatk_maks2,ldc_tulu_summa2,ldc_tvtk_summa2,ldc_pens_summa2,ldc_tatk_summa2,ldc_tulu_summa3,ldc_tvtk_summa3,ldc_pens_summa3,ldc_tatk_summa3
        from pa_tasu left outer join pa_leping on pa_tasu.lepnr = pa_leping.lepnr
                     left outer join pa_taslist as pa_taslist on pa_tasu.tas_s = pa_taslist.tas_s
                     left outer join pa_taslist as pa_taslist_b on pa_tasu.vtas_s = pa_taslist_b.tas_s
                     left outer join pa_tasu as pa_tasu_b on pa_tasu.vtasunr=pa_tasu_b.tasunr and pa_tasu.va_aasta=pa_tasu_b.a_aasta
                     left outer join skoobid on pa_leping.skoop=skoobid.skoop
        where pa_leping.asutnr=li_asutnr and
             if pa_taslist.vmkood is null then pa_taslist_b.vmkood else pa_taslist.vmkood endif=ls_vmkood and
           ((pa_tasu.vtasunr is null and (pa_tasu.t_aasta=li_t_aasta and pa_tasu.t_akuu=li_t_akuu)) or (pa_tasu.vtasunr is not null and (pa_tasu_b.t_aasta=li_t_aasta and pa_tasu_b.t_akuu=li_t_akuu))) and
             skoobid.kood=ls_skoopkood;
      if ldc_maksuvaba2 is null then
        set ldc_maksuvaba2=0
      end if;
      if ldc_tulu_maks2 is null then
        set ldc_tulu_maks2=0
      end if;
      if ldc_tvtk_maks2 is null then
        set ldc_tvtk_maks2=0
      end if;
      if ldc_pens_maks2 is null then
        set ldc_pens_maks2=0
      end if;
      if ldc_tatk_maks2 is null then
        set ldc_tatk_maks2=0
      end if;
      if ldc_tulu_summa2 is null then
        set ldc_tulu_summa2=0
      end if;
      if ldc_tvtk_summa2 is null then
        set ldc_tvtk_summa2=0
      end if;
      if ldc_pens_summa2 is null then
        set ldc_pens_summa2=0
       end if;
      if ldc_tatk_summa2 is null then
        set ldc_tatk_summa2=0
      end if;
      if ldc_tulu_summa3 is null then
        set ldc_tulu_summa3=0
      end if;
      if ldc_tvtk_summa3 is null then
        set ldc_tvtk_summa3=0
      end if;
      if ldc_pens_summa3 is null then
        set ldc_pens_summa3=0
      end if;
      if ldc_tatk_summa3 is null then
        set ldc_tatk_summa3=0
      end if;
--message 'siit algab '+ls_vmkood;
--message 'maksuvaba2';
--message ldc_maksuvaba2;
--message 'kuu_maksuvaba3';
--message ldc_jaga_maksuvaba3;
--message 'tulu_maks2';
--message ldc_tulu_maks2;
--message 'pens_maks2';
--message ldc_pens_maks2;
--message 'tulu_summa2';
--message ldc_tulu_summa2;
--message 'pens_summa2';
--message ldc_pens_summa2;
--message 'tulu_summa3';
--message ldc_tulu_summa3;
      -- tooandja tootuskindlustus
      set ldc_tatk_maks3=Round((ldc_tatk_summa2+ldc_tatk_summa3)*ldc_tatk_protsent/100,2)-ldc_tatk_maks2;
      -- prop
      if ldc_tatk_summa3 = 0 then
        set ldc_tatk_prop=0
      else
        set ldc_tatk_prop=ldc_tatk_maks3/ldc_tatk_summa3
      end if;
      -- toovotja tootuskindlustus
      set ldc_tvtk_maks3=Round((ldc_tvtk_summa2+ldc_tvtk_summa3)*ldc_tvtk_protsent/100,2)-ldc_tvtk_maks2;
      -- prop
      if ldc_tvtk_summa3 = 0 then
        set ldc_tvtk_prop=0
      else
        set ldc_tvtk_prop=ldc_tvtk_maks3/ldc_tvtk_summa3
      end if;
      -- kogumispension
      set ldc_pens_maks3=Round((ldc_pens_summa2+ldc_pens_summa3)*ldc_pens_protsent/100,2)-ldc_pens_maks2;
      -- prop
      if ldc_pens_summa3 = 0 then
        set ldc_pens_prop=0
      else
        set ldc_pens_prop=ldc_pens_maks3/ldc_pens_summa3
      end if;
      -- tulumaks
      if li_tmt=0 then
        set ldc_tulu_maks3=0-ldc_tulu_maks2;
      else
        -- kasutamata maksuvaba
        set ldc_maksuvaba3=ldc_jaga_maksuvaba3;
        -- maksustatav summa ldc_tulu_summa2
        if li_mres = 1 then
          set ldc_tulu_summa2=ldc_tulu_summa2+ldc_tulu_summa3-ldc_tvtk_maks2-ldc_tvtk_maks3
        else
          set ldc_tulu_summa2=ldc_tulu_summa2+ldc_tulu_summa3-ldc_tvtk_maks2-ldc_tvtk_maks3-ldc_pens_maks2-ldc_pens_maks3
        end if;
        -- maksustatav summa kokku ei saa olla negatiivne. muudatus 13.09.2016
        if ldc_tulu_summa2<0 then
          set ldc_tulu_summa2=0
        end if;
        -- maksuvaba 630 ei saa olla suurem, kui maksustatav summa
        if ldc_maksuvaba3_630>ldc_tulu_summa2 then
          set ldc_maksuvaba3_630=ldc_tulu_summa2
        end if;
        -- kuu maksuvaba ei saa olla suurem, kui kuu maksustatav summa
        if ldc_maksuvaba2+ldc_maksuvaba3+ldc_maksuvaba3_630>ldc_tulu_summa2 then
          set ldc_maksuvaba3=ldc_tulu_summa2-ldc_maksuvaba2-ldc_maksuvaba3_630
        end if;
        set ldc_tulu_maks3=Round((ldc_tulu_summa2-(ldc_maksuvaba2+ldc_maksuvaba3+ldc_maksuvaba3_630))*ldc_tulu_protsent_arvuta/100,2)-(ldc_tulu_maks2);
      end if;
      -- kasutamata maksuvaba
      set ldc_jaga_maksuvaba3=ldc_jaga_maksuvaba3-ldc_maksuvaba3;
      -- prop
      if ldc_tulu_summa3 = 0 then
        set ldc_tulu_prop=0
      else
        set ldc_tulu_prop=ldc_tulu_maks3/ldc_tulu_summa3
      end if;
      -- maksu jagamine tasude ridadele
      set li_tasunr=0;
      open c_tasu;
      tasu_loop: loop
        fetch next c_tasu into li_tasunr,li_a_aasta,ldc_summa3,li_sisse,li_tulu,li_tvtk,li_tasu_pens,li_tatk;
        if sqlstate = err_notfound then
          leave tasu_loop
        end if;
        if li_tatk = 1 then
          set ldc_tatk_maks4=Round(ldc_summa3*ldc_tatk_prop,2);
          if li_sisse = 0 then
            set ldc_tatk_maks3=ldc_tatk_maks3-ldc_tatk_maks4
          else
            set ldc_tatk_maks3=ldc_tatk_maks3+ldc_tatk_maks4
          end if;
          update pa_tasu set pa_tasu.tatkmaks = ldc_tatk_maks4 where pa_tasu.tasunr = li_tasunr and pa_tasu.a_aasta = li_a_aasta;
          set li_last_tatk_tasunr=li_tasunr;
          set li_last_tatk_a_aasta=li_a_aasta;
          set li_last_tatk_sisse=li_sisse
        else
          update pa_tasu set pa_tasu.tatkmaks = 0 where pa_tasu.tasunr = li_tasunr and pa_tasu.a_aasta = li_a_aasta
        end if;
        if li_tvtk = 1 then
          set ldc_tvtk_maks4=Round(ldc_summa3*ldc_tvtk_prop,2);
          if li_sisse = 0 then
            set ldc_tvtk_maks3=ldc_tvtk_maks3-ldc_tvtk_maks4
          else
            set ldc_tvtk_maks3=ldc_tvtk_maks3+ldc_tvtk_maks4
          end if;
          update pa_tasu set pa_tasu.tvtkmaks = ldc_tvtk_maks4 where pa_tasu.tasunr = li_tasunr and pa_tasu.a_aasta = li_a_aasta;
          set li_last_tvtk_tasunr=li_tasunr;
          set li_last_tvtk_a_aasta=li_a_aasta;
          set li_last_tvtk_sisse=li_sisse
        else
          update pa_tasu set pa_tasu.tvtkmaks = 0 where pa_tasu.tasunr = li_tasunr and pa_tasu.a_aasta = li_a_aasta
        end if;
        if li_tasu_pens = 1 then
          set ldc_pens_maks4=Round(ldc_summa3*ldc_pens_prop,2);
          if li_sisse = 0 then
            set ldc_pens_maks3=ldc_pens_maks3-ldc_pens_maks4
          else
            set ldc_pens_maks3=ldc_pens_maks3+ldc_pens_maks4
          end if;
          update pa_tasu set pa_tasu.pensmaks = ldc_pens_maks4 where pa_tasu.tasunr = li_tasunr and pa_tasu.a_aasta = li_a_aasta;
          set li_last_pens_tasunr=li_tasunr;
          set li_last_pens_a_aasta=li_a_aasta;
          set li_last_pens_sisse=li_sisse
        else
          update pa_tasu set pa_tasu.pensmaks = 0 where pa_tasu.tasunr = li_tasunr and pa_tasu.a_aasta = li_a_aasta
        end if;
        if li_tulu = 1 then
          set ldc_tulu_maks4=Round(ldc_summa3*ldc_tulu_prop,2);
          if li_sisse = 0 then
            set ldc_tulu_maks3=ldc_tulu_maks3-ldc_tulu_maks4
          else
            set ldc_tulu_maks3=ldc_tulu_maks3+ldc_tulu_maks4
          end if;
          update pa_tasu set pa_tasu.tulumaks = ldc_tulu_maks4 where pa_tasu.tasunr = li_tasunr and pa_tasu.a_aasta = li_a_aasta;
          set li_last_tulu_tasunr=li_tasunr;
          set li_last_tulu_a_aasta=li_a_aasta;
          set li_last_tulu_sisse=li_sisse
        else
          update pa_tasu set pa_tasu.tulumaks = 0 where pa_tasu.tasunr = li_tasunr and pa_tasu.a_aasta = li_a_aasta
        end if
      end loop tasu_loop;
      close c_tasu;
      if ldc_tatk_maks3 <> 0 and li_last_tatk_tasunr > 0 then
        update pa_tasu set pa_tasu.tatkmaks = pa_tasu.tatkmaks+if li_last_tatk_sisse = 0 then ldc_tatk_maks3 else-1*ldc_tatk_maks3 endif where pa_tasu.tasunr = li_last_tatk_tasunr and pa_tasu.a_aasta = li_last_tatk_a_aasta;
        set ldc_tatk_maks3=0
      end if;
      if ldc_tvtk_maks3 <> 0 and li_last_tvtk_tasunr > 0 then
        update pa_tasu set pa_tasu.tvtkmaks = pa_tasu.tvtkmaks+if li_last_tvtk_sisse = 0 then ldc_tvtk_maks3 else-1*ldc_tvtk_maks3 endif where pa_tasu.tasunr = li_last_tvtk_tasunr and pa_tasu.a_aasta = li_last_tvtk_a_aasta;
        set ldc_tvtk_maks3=0
      end if;
      if ldc_pens_maks3 <> 0 and li_last_pens_tasunr > 0 then
        update pa_tasu set pa_tasu.pensmaks = pa_tasu.pensmaks+if li_last_pens_sisse = 0 then ldc_pens_maks3 else-1*ldc_pens_maks3 endif where pa_tasu.tasunr = li_last_pens_tasunr and pa_tasu.a_aasta = li_last_pens_a_aasta;
        set ldc_pens_maks3=0
      end if;
      if (ldc_tulu_maks3<>0 or ldc_tatk_maks3<>0 or ldc_tvtk_maks3<>0 or ldc_pens_maks3<>0) and li_last_tulu_tasunr > 0 then
        if ldc_tulu_maks3 <> 0 then
          update pa_tasu set pa_tasu.tulumaks = pa_tasu.tulumaks+if li_last_tulu_sisse = 0 then ldc_tulu_maks3 else-1*ldc_tulu_maks3 endif where pa_tasu.tasunr = li_last_tulu_tasunr and pa_tasu.a_aasta = li_last_tulu_a_aasta
        end if;
        if ldc_tatk_maks3 <> 0 then
          update pa_tasu set pa_tasu.tatkmaks = pa_tasu.tatkmaks+if li_last_tulu_sisse = 0 then ldc_tatk_maks3 else-1*ldc_tatk_maks3 endif where pa_tasu.tasunr = li_last_tulu_tasunr and pa_tasu.a_aasta = li_last_tulu_a_aasta
        end if;
        if ldc_tvtk_maks3 <> 0 then
          update pa_tasu set pa_tasu.tvtkmaks = pa_tasu.tvtkmaks+if li_last_tulu_sisse = 0 then ldc_tvtk_maks3 else-1*ldc_tvtk_maks3 endif where pa_tasu.tasunr = li_last_tulu_tasunr and pa_tasu.a_aasta = li_last_tulu_a_aasta
        end if;
        if ldc_pens_maks3 <> 0 then
          update pa_tasu set pa_tasu.pensmaks = pa_tasu.pensmaks+if li_last_tulu_sisse = 0 then ldc_pens_maks3 else-1*ldc_pens_maks3 endif where pa_tasu.tasunr = li_last_tulu_tasunr and pa_tasu.a_aasta = li_last_tulu_a_aasta
        end if
      end if;
      if ldc_maksuvaba3 <> 0 and li_last_tulu_tasunr > 0 then
        update pa_tasu set pa_tasu.maksuvaba = pa_tasu.maksuvaba+if li_last_tulu_sisse = 0 then ldc_maksuvaba3 else-1*ldc_maksuvaba3 endif where pa_tasu.tasunr = li_last_tulu_tasunr and pa_tasu.a_aasta = li_last_tulu_a_aasta;
      end if;
      if ldc_maksuvaba3_630 <> 0 and li_last_tulu_tasunr > 0 then
        update pa_tasu set pa_tasu.maksuvaba_630 = pa_tasu.maksuvaba_630+if li_last_tulu_sisse = 0 then ldc_maksuvaba3_630 else-1*ldc_maksuvaba3_630 endif where pa_tasu.tasunr = li_last_tulu_tasunr and pa_tasu.a_aasta = li_last_tulu_a_aasta;
      end if;
    end loop vmkood_loop;
    close c_vmkood;
    open c_maksper;
    maksper_loop: loop
      fetch next c_maksper into li_m_aasta,li_m_akuu;
      if sqlstate = err_notfound then
        leave maksper_loop
      end if;
      set ld_perlop=get_perlop(ymd(li_m_aasta,li_m_akuu,1));
      -- yldised maarad
      set li_penskar=get_penskar(li_asutnr,li_m_aasta);
      if li_penskar=1 then
        set ldc_tulu_vaba_maar=get_maar(15,ld_perlop);
      else
        set ldc_tulu_vaba_maar=get_maar(1,ld_perlop);
      end if;
      set ldc_tulu_protsent=get_maar(2,ld_perlop);
      set ldc_tulu_protsent_erand=10;
      set ldc_tvtk_protsent=get_maar(3,ld_perlop);
      set ldc_pens_protsent=get_maar(4,ld_perlop);
      set ldc_tatk_protsent=get_maar(5,ld_perlop);
    -- tulumaks
      set li_tmt=get_pa_kaader_tun_tmt(li_asutnr,ld_perlop,ls_skoopkood);
      if li_tmt=0 then
        set ldc_tulu_vaba=0;
        set ldc_tulu_protsent=0;
        set ldc_tulu_protsent_erand=0
      else
        if li_tmt=2 then
          set ldc_tulu_vaba=0
        else
          set ldc_mvaba=get_pa_kaader_tun_mvaba(li_asutnr,ld_perlop,ls_skoopkood);
          if ldc_mvaba>0 and ldc_mvaba<ldc_tulu_vaba_maar then
            set ldc_tulu_vaba=ldc_mvaba
          else
            set ldc_tulu_vaba=ldc_tulu_vaba_maar
          end if
        end if
      end if;
      -- tootuskindlustus
      set li_tk=get_pa_kaader_tun_tk(li_asutnr,ld_perlop,ls_skoopkood);
      if li_tk>1 then
        set li_tk=get_tk_tunnus(li_asutnr,li_m_aasta,li_m_akuu)
      end if;
      -- pensionikindlustus
      set li_pens = get_pens_tunnus(li_asutnr,li_m_aasta,li_m_akuu);
      -- varasem kasutatud maksuvaba ja maksustatav summa
      select sum(((-2)*pa_taslist.sisse+1)*pa_tasu.maksuvaba),
             sum(if pa_taslist.tulu=1 then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif)
        into ldc_maksuvaba2,ldc_tulu_summa2
        from pa_tasu left outer join pa_leping on pa_tasu.lepnr = pa_leping.lepnr
                     left outer join pa_taslist as pa_taslist on pa_tasu.tas_s = pa_taslist.tas_s
                     left outer join pa_taslist as pa_taslist_b on pa_tasu.vtas_s = pa_taslist_b.tas_s
                     left outer join pa_tasu as pa_tasu_b on pa_tasu.vtasunr=pa_tasu_b.tasunr and pa_tasu.va_aasta=pa_tasu_b.a_aasta
                     left outer join skoobid on pa_leping.skoop=skoobid.skoop
        where pa_leping.asutnr=li_asutnr and ((pa_tasu.vtasunr is null and (pa_tasu.t_aasta=li_m_aasta and pa_tasu.t_akuu=li_m_akuu)) or (pa_tasu.vtasunr is not null and (pa_tasu_b.t_aasta=li_m_aasta and pa_tasu_b.t_akuu=li_m_akuu))) and skoobid.kood=ls_skoopkood;
      -- and (pa_tasu.t_aasta=li_t_aasta and pa_tasu.t_akuu=li_t_akuu) eemaldatud arusaamatul pohjusel
      if ldc_maksuvaba2 is null then
        set ldc_maksuvaba2=0
      end if;
      if ldc_tulu_summa2 is null then
        set ldc_tulu_summa2=0
      end if;
      -- oigus kasutada maksuvaba
      if li_m_aasta>2017 and li_penskar=0 then
        set ldc_tulu_vaba_oigus=Round(ldc_tulu_vaba_maar-((ldc_tulu_vaba_maar/900)*(ldc_tulu_summa2-1200)),2);
        if ldc_tulu_vaba_oigus>ldc_tulu_vaba_maar then
          set ldc_tulu_vaba_oigus=ldc_tulu_vaba_maar
        end if;
        if ldc_tulu_vaba_oigus<0 then
          set ldc_tulu_vaba_oigus=0
        end if;
        if ldc_tulu_vaba>ldc_tulu_vaba_oigus then
          set ldc_tulu_vaba=ldc_tulu_vaba_oigus
        end if;
      end if;
      -- kuu kasutamata maksuvaba
      set ldc_jaga_maksuvaba3=ldc_tulu_vaba-ldc_maksuvaba2;
      -- ei saa olla positiivne
      if ldc_jaga_maksuvaba3 > 0 then
        set ldc_jaga_maksuvaba3=0
      end if;
      -- valjamakseliikide loikes
      open c_maksvmkood;
      maksvmkood_loop: loop
        fetch next c_maksvmkood into ls_vmkood;
        if sqlstate = err_notfound then
          leave maksvmkood_loop
        end if;
        if ls_vmkood in ('46','150','151','152','153','168','170','180','182','183','184','187','188','189','190','191','192','193','194','195') then
          set ldc_tulu_protsent_arvuta=ldc_tulu_protsent_erand
        else
          set ldc_tulu_protsent_arvuta=ldc_tulu_protsent
        end if;
        -- lisa maksuvaba, kui vmkood='25'
        if ls_vmkood='25' then
          -- tulumaksuga maksustatud summa, millest 15% maksuvaba
          set ldc_summa3=0;
          select sum(((-2)*pa_taslist.sisse+1)*pa_tasu.summa)
            into ldc_summa3
            from pa_tasu left outer join pa_leping on pa_tasu.lepnr = pa_leping.lepnr
                         left outer join pa_taslist as pa_taslist on pa_tasu.tas_s = pa_taslist.tas_s
                         left outer join pa_tasu as pa_tasu_b on pa_tasu.vtasunr=pa_tasu_b.tasunr and pa_tasu.va_aasta=pa_tasu_b.a_aasta
                         left outer join skoobid on pa_leping.skoop=skoobid.skoop
            where pa_leping.asutnr=li_asutnr and pa_taslist.tulu=1 and
                ((pa_tasu.vtasunr is null and pa_tasu.t_aasta=li_m_aasta and pa_tasu.t_akuu<=li_m_akuu) or (pa_tasu.vtasunr is not null and pa_tasu_b.t_aasta=li_m_aasta and pa_tasu_b.t_akuu<=li_m_akuu)) and
                  skoobid.kood=ls_skoopkood;
          if ldc_summa3 is null then
            set ldc_maksuvaba3_630=0
          else
            set ldc_maksuvaba3_630=Round(ldc_summa3*0.15,2)
          end if;
          -- varem arvestatud III sammas, mis vhendab maksuvaba
          set ldc_summa3=0;
          select sum(if (pa_tasu.palgaleht is not null or pa_tasu.lepnr<>a_lepnr or pa_tasu.vtasunr is not null) then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif)
            into ldc_summa3
            from pa_tasu left outer join pa_leping on pa_tasu.lepnr = pa_leping.lepnr
                         left outer join pa_taslist as pa_taslist on pa_tasu.tas_s = pa_taslist.tas_s
                         left outer join pa_taslist as pa_taslist_b on pa_tasu.vtas_s = pa_taslist_b.tas_s
                         left outer join pa_tasu as pa_tasu_b on pa_tasu.vtasunr=pa_tasu_b.tasunr and pa_tasu.va_aasta=pa_tasu_b.a_aasta
                         left outer join skoobid on pa_leping.skoop=skoobid.skoop
            where pa_leping.asutnr=li_asutnr and
                  if pa_taslist.vmkood is null then pa_taslist_b.vmkood else pa_taslist.vmkood endif='25' and
                ((pa_tasu.vtasunr is null and pa_tasu.t_aasta=li_m_aasta and pa_tasu.t_akuu<=li_m_akuu) or (pa_tasu.vtasunr is not null and pa_tasu_b.t_aasta=li_m_aasta and pa_tasu_b.t_akuu<=li_m_akuu)) and
                  skoobid.kood=ls_skoopkood;
            if ldc_summa3<>0 then
              set ldc_maksuvaba3_630=ldc_maksuvaba3_630-ldc_summa3;
              if ldc_maksuvaba3_630<0 then
                set ldc_maksuvaba3_630=0
              end if;
            end if;
        else
          set ldc_maksuvaba3_630=0
        end if;
        -- kuu maksuvaba, varasem maks, varasem maksustatav summa ja kinnipidamata maksustatav summa
        -- Dekl 12 voi Maks 12
        select sum(((-2)*pa_taslist.sisse+1)*pa_tasu.maksuvaba),
               sum(((-2)*pa_taslist.sisse+1)*pa_tasu.tulumaks),
               sum(((-2)*pa_taslist.sisse+1)*pa_tasu.tvtkmaks),
               sum(((-2)*pa_taslist.sisse+1)*pa_tasu.pensmaks),
               sum(((-2)*pa_taslist.sisse+1)*pa_tasu.tatkmaks),
               -- kui on palgalehes voi tagasiarvestus
               sum(if pa_taslist.tulu=1 and (pa_tasu.palgaleht is not null or pa_tasu.lepnr<>a_lepnr or pa_tasu.vtasunr is null) then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif),
               sum(if pa_taslist.tk=1 and li_tk=1 and (pa_tasu.palgaleht is not null or pa_tasu.lepnr<>a_lepnr or pa_tasu.vtasunr is null) then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif),
               sum(if pa_taslist.pens=1 and li_pens>0 and (pa_tasu.palgaleht is not null or pa_tasu.lepnr<>a_lepnr or pa_tasu.vtasunr is null) then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif),
               sum(if pa_taslist.tatk=1 and (pa_tasu.palgaleht is not null or pa_tasu.lepnr<>a_lepnr or pa_tasu.vtasunr is null) then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif),
               -- kui ei ole palgalehes ja ei ole tagasiarvestus
               sum(if pa_taslist.tulu=1 and pa_tasu.palgaleht is null and pa_tasu.lepnr=a_lepnr and pa_tasu.vtasunr is not null then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif),
               sum(if pa_taslist.tk=1 and li_tk=1 and pa_tasu.palgaleht is null and pa_tasu.lepnr=a_lepnr and pa_tasu.vtasunr is not null then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif),
               sum(if pa_taslist.pens=1 and li_pens>0 and pa_tasu.palgaleht is null and pa_tasu.lepnr=a_lepnr and pa_tasu.vtasunr is not null then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif),
               sum(if pa_taslist.tatk=1 and pa_tasu.palgaleht is null and pa_tasu.lepnr=a_lepnr and pa_tasu.vtasunr is not null then ((-2)*pa_taslist.sisse+1)*pa_tasu.summa else 0 endif)
          into ldc_maksuvaba2,ldc_tulu_maks2,ldc_tvtk_maks2,ldc_pens_maks2,ldc_tatk_maks2,ldc_tulu_summa2,ldc_tvtk_summa2,ldc_pens_summa2,ldc_tatk_summa2,ldc_tulu_summa3,ldc_tvtk_summa3,ldc_pens_summa3,ldc_tatk_summa3
          from pa_tasu left outer join pa_leping on pa_tasu.lepnr = pa_leping.lepnr
                       left outer join pa_taslist as pa_taslist on pa_tasu.tas_s = pa_taslist.tas_s
                       left outer join pa_taslist as pa_taslist_b on pa_tasu.vtas_s = pa_taslist_b.tas_s
                       left outer join pa_tasu as pa_tasu_b on pa_tasu.vtasunr=pa_tasu_b.tasunr and pa_tasu.va_aasta=pa_tasu_b.a_aasta
                       left outer join skoobid on pa_leping.skoop=skoobid.skoop
          where pa_leping.asutnr=li_asutnr and if pa_taslist.vmkood is null then pa_taslist_b.vmkood else pa_taslist.vmkood endif=ls_vmkood and ((pa_tasu.vtasunr is null and (pa_tasu.t_aasta=li_m_aasta and pa_tasu.t_akuu=li_m_akuu)) or (pa_tasu.vtasunr is not null and (pa_tasu_b.t_aasta=li_m_aasta and pa_tasu_b.t_akuu=li_m_akuu))) and skoobid.kood=ls_skoopkood;
          --  and (pa_tasu.t_aasta=li_t_aasta and pa_tasu.t_akuu=li_t_akuu) eemaldatud arusaamatul pohjusel
        if ldc_maksuvaba2 is null then
          set ldc_maksuvaba2=0
        end if;
        if ldc_tulu_maks2 is null then
          set ldc_tulu_maks2=0
        end if;
        if ldc_tvtk_maks2 is null then
          set ldc_tvtk_maks2=0
        end if;
        if ldc_pens_maks2 is null then
          set ldc_pens_maks2=0
        end if;
        if ldc_tatk_maks2 is null then
          set ldc_tatk_maks2=0
        end if;
        if ldc_tulu_summa2 is null then
          set ldc_tulu_summa2=0
        end if;
        if ldc_tvtk_summa2 is null then
          set ldc_tvtk_summa2=0
        end if;
        if ldc_pens_summa2 is null then
          set ldc_pens_summa2=0
        end if;
        if ldc_tatk_summa2 is null then
          set ldc_tatk_summa2=0
        end if;
        if ldc_tulu_summa3 is null then
          set ldc_tulu_summa3=0
        end if;
        if ldc_tvtk_summa3 is null then
          set ldc_tvtk_summa3=0
        end if;
        if ldc_pens_summa3 is null then
          set ldc_pens_summa3=0
        end if;
        if ldc_tatk_summa3 is null then
          set ldc_tatk_summa3=0
        end if;
--message 'siit varasem kuu algab '+ls_vmkood;
--message 'maksuvaba2';
--message ldc_maksuvaba2;
--message 'tulu_maks2';
--message ldc_tulu_maks2;
--message 'tulu_summa2';
--message ldc_tulu_summa2;
--message 'tulu_summa3';
--message ldc_tulu_summa3;
--message 'tvtk_maks2';
--message ldc_tvtk_maks2;
--message 'tvtk_summa2';
--message ldc_tvtk_summa2;
--message 'tvtk_summa3';
--message ldc_tvtk_summa3;
        -- tooandja tootuskindlustus
        set ldc_tatk_maks3=Round((ldc_tatk_summa2+ldc_tatk_summa3)*ldc_tatk_protsent/100,2)-ldc_tatk_maks2;
        -- prop
        if ldc_tatk_summa3 = 0 then
          set ldc_tatk_prop=0
        else
          set ldc_tatk_prop=ldc_tatk_maks3/ldc_tatk_summa3
        end if;
        -- toovotja tootuskindlustus
        set ldc_tvtk_maks3=Round((ldc_tvtk_summa2+ldc_tvtk_summa3)*ldc_tvtk_protsent/100,2)-ldc_tvtk_maks2;
        -- prop
        if ldc_tvtk_summa3 = 0 then
          set ldc_tvtk_prop=0
        else
          set ldc_tvtk_prop=ldc_tvtk_maks3/ldc_tvtk_summa3
        end if;
        -- kogumispension
        set ldc_pens_maks3=Round((ldc_pens_summa2+ldc_pens_summa3)*ldc_pens_protsent/100,2)-ldc_pens_maks2;
        -- prop
        if ldc_pens_summa3 = 0 then
          set ldc_pens_prop=0
        else
          set ldc_pens_prop=ldc_pens_maks3/ldc_pens_summa3
        end if;
        -- tulumaks
        if li_tmt=0 then
          set ldc_tulu_maks3=0-ldc_tulu_maks2;
        else
          -- kasutamata maksuvaba
          set ldc_maksuvaba3=ldc_jaga_maksuvaba3;
          -- maksustatav summa ldc_tulu_summa2
          if li_mres = 1 then
            set ldc_tulu_summa2=ldc_tulu_summa2+ldc_tulu_summa3-ldc_tvtk_maks2-ldc_tvtk_maks3
          else
            set ldc_tulu_summa2=ldc_tulu_summa2+ldc_tulu_summa3-ldc_tvtk_maks2-ldc_tvtk_maks3-ldc_pens_maks2-ldc_pens_maks3
          end if;
          -- maksustatav summa kuus kokku ei saa olla negatiivne. muudatus 13.09.2016
          if ldc_tulu_summa2<0 then
            set ldc_tulu_summa2=0
          end if;
          -- maksuvaba 630 ei saa olla suurem, kui maksustatav summa
          if ldc_maksuvaba3_630>ldc_tulu_summa2 then
            set ldc_maksuvaba3_630=ldc_tulu_summa2
          end if;
          -- kuu maksuvaba ei saa olla suurem, kui kuu maksustatav summa
          if ldc_maksuvaba2+ldc_maksuvaba3+ldc_maksuvaba3_630>ldc_tulu_summa2 then
            set ldc_maksuvaba3=ldc_tulu_summa2-ldc_maksuvaba2-ldc_maksuvaba3_630
          end if;
          set ldc_tulu_maks3=Round((ldc_tulu_summa2-(ldc_maksuvaba2+ldc_maksuvaba3+ldc_maksuvaba3_630))*ldc_tulu_protsent_arvuta/100,2)-(ldc_tulu_maks2);
        end if;
        -- prop
        if ldc_tulu_summa3 = 0 then
          set ldc_tulu_prop=0
        else
          set ldc_tulu_prop=ldc_tulu_maks3/ldc_tulu_summa3
        end if;
        -- maksu jagamine tasude ridadele
        set li_tasunr=0;
        open c_makstasu;
        makstasu_loop: loop
          fetch next c_makstasu into li_tasunr,li_a_aasta,ldc_summa3,li_sisse,li_tulu,li_tvtk,li_tasu_pens,li_tatk;
          if sqlstate = err_notfound then
            leave makstasu_loop
          end if;
          if li_tatk = 1 then
            set ldc_tatk_maks4=Round(ldc_summa3*ldc_tatk_prop,2);
            if li_sisse = 0 then
              set ldc_tatk_maks3=ldc_tatk_maks3-ldc_tatk_maks4
            else
              set ldc_tatk_maks3=ldc_tatk_maks3+ldc_tatk_maks4
            end if;
            update pa_tasu set pa_tasu.tatkmaks = ldc_tatk_maks4 where pa_tasu.tasunr = li_tasunr and pa_tasu.a_aasta = li_a_aasta;
            set li_last_tatk_tasunr=li_tasunr;
            set li_last_tatk_a_aasta=li_a_aasta;
            set li_last_tatk_sisse=li_sisse
          else
            update pa_tasu set pa_tasu.tatkmaks = 0 where pa_tasu.tasunr = li_tasunr and pa_tasu.a_aasta = li_a_aasta
          end if;
          if li_tvtk = 1 then
            set ldc_tvtk_maks4=Round(ldc_summa3*ldc_tvtk_prop,2);
            if li_sisse = 0 then
              set ldc_tvtk_maks3=ldc_tvtk_maks3-ldc_tvtk_maks4
            else
              set ldc_tvtk_maks3=ldc_tvtk_maks3+ldc_tvtk_maks4
            end if;
            update pa_tasu set pa_tasu.tvtkmaks = ldc_tvtk_maks4 where pa_tasu.tasunr = li_tasunr and pa_tasu.a_aasta = li_a_aasta;
            set li_last_tvtk_tasunr=li_tasunr;
            set li_last_tvtk_a_aasta=li_a_aasta;
            set li_last_tvtk_sisse=li_sisse
          else
            update pa_tasu set pa_tasu.tvtkmaks = 0 where pa_tasu.tasunr = li_tasunr and pa_tasu.a_aasta = li_a_aasta
          end if;
          if li_tasu_pens = 1 then
            set ldc_pens_maks4=Round(ldc_summa3*ldc_pens_prop,2);
            if li_sisse = 0 then
              set ldc_pens_maks3=ldc_pens_maks3-ldc_pens_maks4
            else
              set ldc_pens_maks3=ldc_pens_maks3+ldc_pens_maks4
            end if;
            update pa_tasu set pa_tasu.pensmaks = ldc_pens_maks4 where pa_tasu.tasunr = li_tasunr and pa_tasu.a_aasta = li_a_aasta;
            set li_last_pens_tasunr=li_tasunr;
            set li_last_pens_a_aasta=li_a_aasta;
            set li_last_pens_sisse=li_sisse
          else
            update pa_tasu set pa_tasu.pensmaks = 0 where pa_tasu.tasunr = li_tasunr and pa_tasu.a_aasta = li_a_aasta
          end if;
          if li_tulu = 1 then
            set ldc_tulu_maks4=Round(ldc_summa3*ldc_tulu_prop,2);
            if li_sisse = 0 then
              set ldc_tulu_maks3=ldc_tulu_maks3-ldc_tulu_maks4
            else
              set ldc_tulu_maks3=ldc_tulu_maks3+ldc_tulu_maks4
            end if;
            update pa_tasu set pa_tasu.tulumaks = ldc_tulu_maks4 where pa_tasu.tasunr = li_tasunr and pa_tasu.a_aasta = li_a_aasta;
            set li_last_tulu_tasunr=li_tasunr;
            set li_last_tulu_a_aasta=li_a_aasta;
            set li_last_tulu_sisse=li_sisse
          else
            update pa_tasu set pa_tasu.tulumaks = 0 where pa_tasu.tasunr = li_tasunr and pa_tasu.a_aasta = li_a_aasta
          end if
        end loop makstasu_loop;
        close c_makstasu;
        if ldc_tatk_maks3 <> 0 and li_last_tatk_tasunr > 0 then
          update pa_tasu set pa_tasu.tatkmaks = pa_tasu.tatkmaks+if li_last_tatk_sisse = 0 then ldc_tatk_maks3 else-1*ldc_tatk_maks3 endif where pa_tasu.tasunr = li_last_tatk_tasunr and pa_tasu.a_aasta = li_last_tatk_a_aasta;
          set ldc_tatk_maks3=0
        end if;
        if ldc_tvtk_maks3 <> 0 and li_last_tvtk_tasunr > 0 then
          update pa_tasu set pa_tasu.tvtkmaks = pa_tasu.tvtkmaks+if li_last_tvtk_sisse = 0 then ldc_tvtk_maks3 else-1*ldc_tvtk_maks3 endif where pa_tasu.tasunr = li_last_tvtk_tasunr and pa_tasu.a_aasta = li_last_tvtk_a_aasta;
          set ldc_tvtk_maks3=0
        end if;
        if ldc_pens_maks3 <> 0 and li_last_pens_tasunr > 0 then
          update pa_tasu set pa_tasu.pensmaks = pa_tasu.pensmaks+if li_last_pens_sisse = 0 then ldc_pens_maks3 else-1*ldc_pens_maks3 endif where pa_tasu.tasunr = li_last_pens_tasunr and pa_tasu.a_aasta = li_last_pens_a_aasta;
          set ldc_pens_maks3=0
        end if;
        if (ldc_tulu_maks3<>0 or ldc_tatk_maks3<>0 or ldc_tvtk_maks3<>0 or ldc_pens_maks3<>0) and li_last_tulu_tasunr > 0 then
          if ldc_tulu_maks3 <> 0 then
            update pa_tasu set pa_tasu.tulumaks = pa_tasu.tulumaks+if li_last_tulu_sisse = 0 then ldc_tulu_maks3 else-1*ldc_tulu_maks3 endif where pa_tasu.tasunr = li_last_tulu_tasunr and pa_tasu.a_aasta = li_last_tulu_a_aasta
          end if;
          if ldc_tatk_maks3 <> 0 then
            update pa_tasu set pa_tasu.tatkmaks = pa_tasu.tatkmaks+if li_last_tulu_sisse = 0 then ldc_tatk_maks3 else-1*ldc_tatk_maks3 endif where pa_tasu.tasunr = li_last_tulu_tasunr and pa_tasu.a_aasta = li_last_tulu_a_aasta
          end if;
          if ldc_tvtk_maks3 <> 0 then
            update pa_tasu set pa_tasu.tvtkmaks = pa_tasu.tvtkmaks+if li_last_tulu_sisse = 0 then ldc_tvtk_maks3 else-1*ldc_tvtk_maks3 endif where pa_tasu.tasunr = li_last_tulu_tasunr and pa_tasu.a_aasta = li_last_tulu_a_aasta
          end if;
          if ldc_pens_maks3 <> 0 then
            update pa_tasu set pa_tasu.pensmaks = pa_tasu.pensmaks+if li_last_tulu_sisse = 0 then ldc_pens_maks3 else-1*ldc_pens_maks3 endif where pa_tasu.tasunr = li_last_tulu_tasunr and pa_tasu.a_aasta = li_last_tulu_a_aasta
          end if
        end if;
        if ldc_maksuvaba3 <> 0 and li_last_tulu_tasunr > 0 then
          update pa_tasu set pa_tasu.maksuvaba = pa_tasu.maksuvaba+if li_last_tulu_sisse = 0 then ldc_maksuvaba3 else-1*ldc_maksuvaba3 endif where pa_tasu.tasunr = li_last_tulu_tasunr and pa_tasu.a_aasta = li_last_tulu_a_aasta;
        end if;
        if ldc_maksuvaba3_630 <> 0 and li_last_tulu_tasunr > 0 then
          update pa_tasu set pa_tasu.maksuvaba_630 = pa_tasu.maksuvaba_630+if li_last_tulu_sisse = 0 then ldc_maksuvaba3_630 else-1*ldc_maksuvaba3_630 endif where pa_tasu.tasunr = li_last_tulu_tasunr and pa_tasu.a_aasta = li_last_tulu_a_aasta;
        end if;
      end loop maksvmkood_loop;
      close c_maksvmkood;
    end loop maksper_loop;
    close c_maksper;
    -- kinnipidamised peale tulumaksu
    call pa_kinnip('8c',a_lepnr,li_t_akuu,li_t_aasta);
    call pa_kinnip_panka_III_sammas(a_lepnr,li_t_akuu,li_t_aasta);
    call pa_kinnip_panka(a_lepnr,li_t_akuu,li_t_aasta);
end