CREATE PROCEDURE "DBA"."pa_gl_pa_leping_tun"( in a_lepnr integer, in a_akuup date, in a_lkuup date )
BEGIN
  declare ld_kups date;
  declare ld_kuup1 date;
  declare ld_kuup2 date;
  declare ld_tun_kuup1 date;
  declare ld_tun_kuup2 date;
  declare ldc_koht numeric(6,3);
  declare ldc_eelm_koht numeric(6,3);
  declare ll_person integer;
  declare ll_leping_person integer;
  declare ll_eelm_person integer;
  declare err_notfound exception for sqlstate value '02000';
  declare c_tun dynamic scroll cursor for select kuup1,Round(ntn/5*koht,3),if person is null then ll_leping_person else person endif from pa_leping_tun where pa_leping_tun.lepnr=a_lepnr and pa_leping_tun.kuup1>=ld_tun_kuup1 and pa_leping_tun.kuup1<=ld_tun_kuup2 order by pa_leping_tun.kuup1 asc;
  delete from gl_pa_leping_tun;
  if month(a_akuup)=month(a_lkuup) and years(a_akuup)=years(a_lkuup) and a_akuup<=a_lkuup then
    select if kuup1>a_akuup then kuup1 else a_akuup endif,if kuup2 is null or kuup2>a_lkuup then a_lkuup else kuup2 endif,person into ld_kuup1,ld_kuup2,ll_leping_person from pa_leping where lepnr=a_lepnr;
    if month(ld_kuup1)=month(ld_kuup2) and years(ld_kuup1)=years(ld_kuup2) and ld_kuup1<=ld_kuup2 then
      select first pa_leping_tun.kuup1 into ld_tun_kuup1 from pa_leping_tun where pa_leping_tun.lepnr=a_lepnr and pa_leping_tun.kuup1<=ld_kuup1 order by pa_leping_tun.kuup1 desc;
      select first pa_leping_tun.kuup1 into ld_tun_kuup2 from pa_leping_tun where pa_leping_tun.lepnr=a_lepnr and pa_leping_tun.kuup1<=ld_kuup2 order by pa_leping_tun.kuup1 desc;
      if ld_tun_kuup1 is null and ld_tun_kuup2 is null then
        insert into gl_pa_leping_tun (kuup1,kuup2,person) values (ld_kuup1,ld_kuup2,ll_leping_person);
      else
        if ld_tun_kuup1 is null then
          set ld_tun_kuup1=ld_kuup1;
        end if;
        -- kui ld_tun_kuup1 ei ole null, siis ld_tun_kuup2 ei saa olla null
        open c_tun;
        tun_loop: loop
          fetch next c_tun into ld_kups,ldc_koht,ll_person;
          if sqlstate = err_notfound then -- kui eof
            leave tun_loop
          end if;
          if ld_kups>ld_kuup1 then
            insert into gl_pa_leping_tun (kuup1,kuup2,koht,person) values (ld_kuup1,dateadd(day,-1,ld_kups),ldc_eelm_koht,ll_eelm_person);
            set ld_kuup1=ld_kups;
          end if;
          set ldc_eelm_koht=ldc_koht;
          set ll_eelm_person=ll_person;
        end loop tun_loop;
        close c_tun;
        insert into gl_pa_leping_tun (kuup1,kuup2,koht,person) values (ld_kuup1,ld_kuup2,ldc_eelm_koht,ll_eelm_person);
      end if;
    end if;
  end if
END