ALTER PROCEDURE "dba"."pa_lipik_koond2"(in a_skoopkood char(16) default '', in a_skoop integer default 0, in a_yksusnr integer default 0, in a_t_aasta numeric(4) default 2019,in a_t_akuu numeric(2) default 1)
begin
  declare ls_t_per char(30);
  delete from gl_tr_lipik2;
  delete from gl_4;
  set ls_t_per='Tasumiseks: '+get_kuu(a_t_akuu)+' '+convert(char(4),a_t_aasta);
  insert into gl_tr_lipik2 (asutnr,lepnr,palgaleht,v_aasta,t_per,yksusnr,tas_s,sisse,algol,akuup,lkuup,par1,par2,par3,par4,par5,summa,"info",tulumaks,tvtkmaks,pensmaks,sotsmaks,tatkmaks,maksuvaba,arvestatud,kinnipeetud,panka)
    select pa_leping.asutnr,
           pa_tasu.lepnr,
           pa_tasu.palgaleht,
           pa_tasu.v_aasta,
           ls_t_per,
           pa_tasu.yksusnr,
           pa_tasu.tas_s,
           max(pa_taslist.sisse),
           max(pa_taslist.algol),
           ymd(pa_tasu.a_aasta,pa_tasu.a_akuu,pa_tasu.a_apaev) as pa_akuup,
           ymd(pa_tasu.a_aasta,pa_tasu.a_akuu,pa_tasu.a_lpaev) as pa_lkuup,
           max(pa_tasu.par1),
           sum(pa_tasu.par2),
           max(pa_tasu.par3),
           sum(pa_tasu.par4),
           max(pa_tasu.par5),
           sum(pa_tasu.summa),
           pa_tasu."info",
           sum(if pa_taslist.sisse=0 then pa_tasu.tulumaks else (-1)*pa_tasu.tulumaks endif),
           sum(if pa_taslist.sisse=0 then pa_tasu.tvtkmaks else (-1)*pa_tasu.tvtkmaks endif),
           sum(if pa_taslist.sisse=0 then pa_tasu.pensmaks else (-1)*pa_tasu.pensmaks endif),
           sum(if pa_taslist.sisse=0 then pa_tasu.sotsmaks else (-1)*pa_tasu.sotsmaks endif),
           sum(if pa_taslist.sisse=0 then pa_tasu.tatkmaks else (-1)*pa_tasu.tatkmaks endif),
           sum(if pa_taslist.sisse=0 then pa_tasu.maksuvaba else (-1)*pa_tasu.maksuvaba endif),
           sum(if pa_taslist.sisse=0 then pa_tasu.summa else 0 endif),
           sum(if pa_taslist.sisse=1 and pa_taslist.algol <> '8o' then pa_tasu.summa else 0 endif),
           sum(if pa_taslist.sisse=1 and pa_taslist.algol = '8o' then pa_tasu.summa else 0 endif)
      from pa_tasu left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
                   left outer join pa_leping on pa_tasu.lepnr=pa_leping.lepnr
                   left outer join pa_yksus on pa_tasu.yksusnr=pa_yksus.yksusnr
                   left outer join skoobid on pa_yksus.skoop=skoobid.skoop
                   left outer join gl_selectall on (pa_leping.asutnr=gl_selectall.id1 or gl_selectall.id1=0) and (pa_tasu.lepnr=gl_selectall.id2 or gl_selectall.id2=0) and ((pa_tasu.palgaleht=gl_selectall.id3 and pa_tasu.v_aasta=gl_selectall.id4) or gl_selectall.id3=0)
      where  pa_taslist.sisse=0 and
             pa_tasu.palgaleht is not null and
             pa_tasu.t_aasta=a_t_aasta and
             pa_tasu.t_akuu=a_t_akuu and
             (pa_tasu.yksusnr=a_yksusnr or a_yksusnr=0 or a_yksusnr is null) and  
             Left(skoobid.kood,Length(a_skoopkood))=a_skoopkood and
             (pa_yksus.skoop=a_skoop or a_skoop=0) and
             gl_selectall.id1 is not null
      group by pa_leping.asutnr,pa_tasu.lepnr,pa_tasu.palgaleht,pa_tasu.v_aasta,pa_tasu.yksusnr,pa_tasu.tas_s,pa_tasu."info",pa_akuup,pa_lkuup;
  insert into gl_tr_lipik2 (asutnr,lepnr,palgaleht,v_aasta,t_per,yksusnr,tas_s,sisse,algol,akuup,lkuup,par1,par2,par3,par4,par5,summa,"info",tulumaks,tvtkmaks,pensmaks,sotsmaks,tatkmaks,maksuvaba,arvestatud,kinnipeetud,panka)
    select pa_leping.asutnr,
           pa_tasu.lepnr,
           pa_tasu.palgaleht,
           pa_tasu.v_aasta,
           ls_t_per,
           pa_tasu.yksusnr,
           pa_tasu.tas_s,
           max(pa_taslist.sisse),
           max(pa_taslist.algol),
           min(ymd(pa_tasu.a_aasta,pa_tasu.a_akuu,pa_tasu.a_apaev)) as pa_akuup,
           max(ymd(pa_tasu.a_aasta,pa_tasu.a_akuu,pa_tasu.a_lpaev)) as pa_lkuup,
           max(pa_tasu.par1),
           sum(pa_tasu.par2),
           max(pa_tasu.par3),
           sum(pa_tasu.par4),
           max(pa_tasu.par5),
           sum(pa_tasu.summa),
           pa_tasu."info",
           sum(if pa_taslist.sisse=0 then pa_tasu.tulumaks else (-1)*pa_tasu.tulumaks endif),
           sum(if pa_taslist.sisse=0 then pa_tasu.tvtkmaks else (-1)*pa_tasu.tvtkmaks endif),
           sum(if pa_taslist.sisse=0 then pa_tasu.pensmaks else (-1)*pa_tasu.pensmaks endif),
           sum(if pa_taslist.sisse=0 then pa_tasu.sotsmaks else (-1)*pa_tasu.sotsmaks endif),
           sum(if pa_taslist.sisse=0 then pa_tasu.tatkmaks else (-1)*pa_tasu.tatkmaks endif),
           sum(if pa_taslist.sisse=0 then pa_tasu.maksuvaba else (-1)*pa_tasu.maksuvaba endif),
           sum(if pa_taslist.sisse=0 then pa_tasu.summa else 0 endif),
           sum(if pa_taslist.sisse=1 and pa_taslist.algol <> '8o' then pa_tasu.summa else 0 endif),
           sum(if pa_taslist.sisse=1 and pa_taslist.algol = '8o' then pa_tasu.summa else 0 endif)
      from pa_tasu left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
                   left outer join pa_leping on pa_tasu.lepnr=pa_leping.lepnr
                   left outer join pa_yksus on pa_tasu.yksusnr=pa_yksus.yksusnr
                   left outer join skoobid on pa_yksus.skoop=skoobid.skoop
                   left outer join gl_selectall on (pa_leping.asutnr=gl_selectall.id1 or gl_selectall.id1=0) and (pa_tasu.lepnr=gl_selectall.id2 or gl_selectall.id2=0) and ((pa_tasu.palgaleht=gl_selectall.id3 and pa_tasu.v_aasta=gl_selectall.id4) or gl_selectall.id3=0)
      where  pa_taslist.sisse=1 and
             pa_tasu.palgaleht is not null and
             pa_tasu.t_aasta=a_t_aasta and
             pa_tasu.t_akuu=a_t_akuu and
             (pa_tasu.yksusnr=a_yksusnr or a_yksusnr=0 or a_yksusnr is null) and  
             Left(skoobid.kood,Length(a_skoopkood))=a_skoopkood and
             (pa_yksus.skoop=a_skoop or a_skoop=0) and
             gl_selectall.id1 is not null
      group by pa_leping.asutnr,pa_tasu.lepnr,pa_tasu.palgaleht,pa_tasu.v_aasta,pa_tasu.yksusnr,pa_tasu.tas_s,pa_tasu."info";
  update gl_tr_lipik2 set kinnipeetud=kinnipeetud + tulumaks + tvtkmaks + pensmaks;
  update gl_tr_lipik2 set saada=arvestatud-kinnipeetud-panka;
  insert into gl_4 (id,kuup1,kuup2)
    select gl_tr_lipik2.lepnr,
           min(gl_tr_lipik2.akuup),
           max(gl_tr_lipik2.lkuup)
      from gl_tr_lipik2
      group by gl_tr_lipik2.lepnr
      order by gl_tr_lipik2.lepnr;
  update gl_4 set kuup1=ymd(a_t_aasta,a_t_akuu,1) where years(kuup1)>a_t_aasta or (years(kuup1)=a_t_aasta and month(kuup1)>a_t_akuu);
  update gl_4 set kuup2=ymd(a_t_aasta,a_t_akuu,25) where years(kuup2)<a_t_aasta or (years(kuup2)=a_t_aasta and month(kuup2)<a_t_akuu);
  update gl_4 set kuup1=get_peralg(kuup1),kuup2=get_perlop(kuup2);
  insert into gl_tr_lipik2 (asutnr,lepnr,t_per,peatnr,sisse,akuup,lkuup,par3,par2,par1)
    select pa_leping.asutnr,
           pa_tgraaf.lepnr,
           ls_t_per,
           pa_tgraaf.peatnr,
           3,
           pa_tgraaf.akuup,
           pa_tgraaf.lkuup,
           pa_tgraaf.lkuup-pa_tgraaf.akuup+1,
           get_kp_arv_per("pa_tgraaf"."akuup","pa_tgraaf"."lkuup"),
           get_tp_arv_per("pa_tgraaf"."akuup","pa_tgraaf"."lkuup")
      from pa_tgraaf left outer join pa_leping on pa_tgraaf.lepnr=pa_leping.lepnr
                     right outer join gl_4 on pa_tgraaf.lepnr=gl_4."id"
      where (pa_tgraaf.akuup<=gl_4.kuup2) and
            (pa_tgraaf.lkuup>=gl_4.kuup1);
end