CREATE PROCEDURE "DBA"."pa_lipik_koond2"(in a_palgaleht integer,in a_v_aasta numeric(4),in a_lepnr integer, in a_v_akuu numeric(2) default 1)
begin
  delete from gl_tr_lipik2;
  insert into gl_tr_lipik2 (asutnr,lepnr,palgaleht,yksusnr,tas_s,sisse,akuup,lkuup,par1,par2,par3,par4,par5,summa,tulumaks,tvtkmaks,pensmaks,sotsmaks,tatkmaks,maksuvaba)
    select pa_leping.asutnr,
           pa_tasu.lepnr,
           pa_tasu.palgaleht,
           pa_tasu.yksusnr,
           pa_tasu.tas_s,
           if pa_taslist.algol='8o' then 2 else pa_taslist.sisse endif as pa_sisse,
           ymd(pa_tasu.a_aasta,pa_tasu.a_akuu,pa_tasu.a_apaev) as pa_akuup,
           ymd(pa_tasu.a_aasta,pa_tasu.a_akuu,pa_tasu.a_lpaev) as pa_lkuup,
           sum(pa_tasu.par1),
           sum(pa_tasu.par2),
           sum(pa_tasu.par3),
           sum(pa_tasu.par4),
           sum(pa_tasu.par5),
           sum(pa_tasu.summa),
           sum(pa_tasu.tulumaks),
           sum(pa_tasu.tvtkmaks),
           sum(pa_tasu.pensmaks),
           sum(pa_tasu.sotsmaks),
           sum(pa_tasu.tatkmaks),
           sum(pa_tasu.maksuvaba)
      from pa_tasu left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
                   left outer join pa_leping on pa_tasu.lepnr=pa_leping.lepnr
      where pa_tasu.palgaleht = a_palgaleht and
            pa_tasu.v_aasta = a_v_aasta and
           (pa_tasu.lepnr=a_lepnr or a_lepnr=0)
      group by pa_leping.asutnr,pa_tasu.lepnr,pa_tasu.palgaleht,pa_tasu.yksusnr,pa_tasu.tas_s,pa_sisse,pa_akuup,pa_lkuup;
  insert into gl_tr_lipik2 (asutnr,lepnr,peatnr,sisse,akuup,lkuup,par1,par2,par3)
    select pa_leping.asutnr,
           pa_tgraaf.lepnr,
           pa_tgraaf.peatnr,
           3,
           pa_tgraaf.akuup,
           pa_tgraaf.lkuup,
           pa_tgraaf.lkuup-pa_tgraaf.akuup+1,
           get_kp_arv_per("pa_tgraaf"."akuup","pa_tgraaf"."lkuup"),
           get_tp_arv_per("pa_tgraaf"."akuup","pa_tgraaf"."lkuup")
      from pa_tgraaf left outer join pa_leping on pa_tgraaf.lepnr=pa_leping.lepnr
      where (pa_tgraaf.lepnr=a_lepnr or a_lepnr=0) AND  
         ( Year(pa_tgraaf.akuup) <= a_v_aasta ) AND  
         ( Month(pa_tgraaf.akuup) <= a_v_akuu ) AND  
         ( Year(pa_tgraaf.lkuup) >= a_v_aasta ) AND  
         ( Month(pa_tgraaf.lkuup) >= a_v_akuu );
end