CREATE PROCEDURE "dba"."pa_stat_keskarv"( in a_skoopkood char(16), in a_skoop integer, in a_yksuskood char(16), in a_yksusnr integer, in a_a_akuu numeric(2), in a_a_aasta char(4), in a_statnr integer default 0)
BEGIN
  declare ld_peralg date;
  declare ld_perlop date;
  declare ldc_kpa decimal(15,2);
  if a_a_akuu=0 then
    set ld_peralg=ymd(a_a_aasta,1,1);
    set ld_perlop=ymd(a_a_aasta,12,31);
  else
    set ld_peralg=ymd(a_a_aasta,a_a_akuu,1);
    set ld_perlop=get_perlop(ymd(a_a_aasta,a_a_akuu,28));
  end if;
  set ldc_kpa=get_kp_arv_per_pta(ld_peralg,ld_perlop);
  delete from gl_tr_universal;
  delete from gl_tr_universal2;
  delete from gl_list;


  insert into gl_list("id1",sum1,kuup1,kuup2,kuup5)
    select pa_isik.lepnr,
           if pa_leping_tun.koht is null then 1 else pa_leping_tun.koht endif as tun_koht,
           min(if pa_isik.kuup1 is null then pa_leping.kuup1 else if pa_isik.kuup1>pa_leping.kuup1 then pa_isik.kuup1 else pa_leping.kuup1 endif endif) as pa_kuup1,
           max(if pa_isik.kuup2 is null then if pa_leping.kuup2 is null then ymd(2500,12,31) else pa_leping.kuup2 endif else if pa_leping.kuup2 is null then pa_isik.kuup2 else if pa_isik.kuup2<pa_leping.kuup2 then pa_isik.kuup2 else pa_leping.kuup2 endif endif endif) as pa_kuup2,
           pa_leping_tun.kuup1 as tun_kuup
      from pa_isik left outer join pa_leping on pa_isik.lepnr=pa_leping.lepnr
                   left outer join pa_yksus on pa_isik.yksusnr = pa_yksus.yksusnr
                   left outer join skoobid on pa_yksus.skoop=skoobid.skoop
                   left outer join pa_leping_tun on pa_isik.lepnr=pa_leping_tun.lepnr
      where ((pa_yksus.skoop = a_skoop or a_skoop = 0) and Left(skoobid.kood,Length(a_skoopkood))=a_skoopkood) and
            ((pa_isik.yksusnr = a_yksusnr or a_yksusnr = 0) and Left(pa_yksus.kood,Length(a_yksuskood))=a_yksuskood) and
            (pa_yksus.statnr = a_statnr or a_statnr = 0) and
            (pa_leping.id_koht=1 or pa_leping.id_koht=4) and
            pa_isik.lepnr=1
       group by pa_isik.lepnr,pa_leping_tun.koht,tun_kuup;
  delete from gl_list where kuup1>ld_perlop or kuup2<ld_peralg or kuup5>ld_perlop;

  
END