ALTER PROCEDURE "DBA"."pa_stat_koond1"( in a_skoopkood char(16), in a_skoop integer, in a_yksuskood char(16), in a_yksusnr integer, in a_a_akuu numeric(2), in a_a_aasta char(4), in a_statnr integer default 0, in a_perver smallint default 2)
BEGIN
  declare ld_peralg date;
  declare ld_perlop date;
  declare ldc_tpa_kuus decimal(15,2);
  declare ldc_kpa_kuus_pta decimal(15,2);
  declare ldc_1 decimal(15,2);
  declare ldc_2 decimal(15,2);
  declare ldc_3 decimal(15,2);
  declare ls_insert char(1500);
  declare ls_periood char(100);
  declare ls_productversion char(100);
  set ld_peralg=ymd(a_a_aasta,a_a_akuu,1);
  set ld_perlop=get_perlop(ymd(a_a_aasta,a_a_akuu,28));
  set ldc_tpa_kuus=get_tp_arv_per(ld_peralg,ld_perlop);
  set ldc_kpa_kuus_pta=get_kp_arv_per_pta(ld_peralg,ld_perlop);
  case a_perver
    when 1 then
      set ls_periood='pa_tasu.t_aasta=a_a_aasta and pa_tasu.t_akuu=a_a_akuu';
    when 2 then
      set ls_periood='pa_tasu.a_aasta=a_a_aasta and pa_tasu.a_akuu=a_a_akuu';
    when 3 then
      set ls_periood='pa_tasu.v_aasta=a_a_aasta and pa_tasu.v_akuu=a_a_akuu';
  end case;
  delete from gl_pa_stat;
  delete from gl_list;
  insert into gl_list("id","id1","sum1","kuup1","kuup2")
  select distinct pa_leping.lepnr,pa_leping.id_koht,get_pa_leping_tun_koht(pa_leping.lepnr,ld_perlop) as pa_leping_tun_koht,if pa_leping.kuup1>ld_peralg then pa_leping.kuup1 else ld_peralg endif, if pa_leping.kuup2 is null or pa_leping.kuup2>ld_perlop then ld_perlop else pa_leping.kuup2 endif
    from pa_leping left outer join pa_isik on pa_leping.lepnr = pa_isik.lepnr left outer join pa_yksus on pa_isik.yksusnr = pa_yksus.yksusnr left outer join skoobid on pa_yksus.skoop=skoobid.skoop
    where (pa_yksus.skoop = a_skoop or a_skoop = 0) and Left(skoobid.kood,Length(a_skoopkood))=a_skoopkood and "Left"(pa_yksus.kood,Length(a_yksuskood))=a_yksuskood and(pa_isik.yksusnr = a_yksusnr or a_yksusnr = 0) and (pa_yksus.statnr = a_statnr or a_statnr = 0)
      and pa_leping.kuup1<=ld_perlop and (pa_leping.kuup2 is null or pa_leping.kuup2>=ld_peralg);
  insert into gl_pa_stat("id",nimi,kood) values (1,'1.1 Tlepingu, teenistusleping ja avaliku teenistuse seaduse alusel ttavad isikud','X1');
  select property('ProductVersion') into ls_productversion from DUMMY;
  if left(ls_productversion,1) in ('7','8') then
    delete from gl_tr_universal;
    insert into gl_tr_universal("id","id1","id2")
      select distinct max(pa_leping.lepnr),pa_leping.id_koht,pa_leping.asutnr
        from pa_leping left outer join pa_isik on pa_leping.lepnr = pa_isik.lepnr left outer join pa_yksus on pa_isik.yksusnr = pa_yksus.yksusnr left outer join skoobid on pa_yksus.skoop=skoobid.skoop
        where (pa_yksus.skoop = a_skoop or a_skoop = 0) and Left(skoobid.kood,Length(a_skoopkood))=a_skoopkood and "Left"(pa_yksus.kood,Length(a_yksuskood))=a_yksuskood and(pa_isik.yksusnr = a_yksusnr or a_yksusnr = 0) and (pa_yksus.statnr = a_statnr or a_statnr = 0)
          and pa_leping.kuup1<=ld_perlop and (pa_leping.kuup2 is null or pa_leping.kuup2>=ld_perlop)
        group by pa_leping.id_koht,pa_leping.asutnr;
    insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
        select 2,
               'Ttajate arv aruandekuu lpul',
               '01',
               count(if gl_tr_universal.id1=1 then gl_tr_universal."id" else null endif) as a_v2,
               count(if gl_tr_universal.id1=4 then gl_tr_universal."id" else null endif) as a_v3,
               a_v2+a_v3
        from gl_tr_universal
        where pa_peat_lapsehp(ld_perlop,gl_tr_universal."id")=0;
    insert into gl_pa_stat("id",nimi,kood,v1)
        select 3,
               'R01V1 nidatud aruandekuu lpul lapsehoolduspuhkusel viibivad ttajad',
               '02',
               count(if gl_tr_universal.id1=1 or gl_tr_universal.id1=4 then gl_tr_universal."id" else null endif)
        from gl_tr_universal
        where pa_peat_lapsehp(ld_perlop,gl_tr_universal."id")=1;
  else
    -- tootajate arv
    insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
        select 2,
               'Ttajate arv aruandekuu lpul',
               '01',
               count(distinct if gl_list.id1=1 then asulist.reg_nr else null endif) as a_v2,
               count(distinct if gl_list.id1=4 then asulist.reg_nr else null endif) as a_v3,
               a_v2+a_v3
        from gl_list left outer join pa_leping on gl_list."id"=pa_leping.lepnr left outer join asulist on pa_leping.asutnr=asulist.asutnr
        where gl_list.kuup2=ld_perlop and pa_peat_lapsehp(ld_perlop,gl_list."id")=0;
    insert into gl_pa_stat("id",nimi,kood,v1)
        select 3,
               'R01V1 nidatud aruandekuu lpul lapsehoolduspuhkusel viibivad ttajad',
               '02',
               count(distinct if gl_list.id1=1 or gl_list.id1=4 then asulist.reg_nr else null endif)
        from gl_list left outer join pa_leping on gl_list."id"=pa_leping.lepnr left outer join asulist on pa_leping.asutnr=asulist.asutnr
        where pa_peat_lapsehp(ld_perlop,gl_list."id")=1;
  end if;
  insert into gl_pa_stat("id",nimi,kood,v1,v3) values (4,'R01 nidatud ttajad, kes ei tta vi ttavad ajutiselt osalise tajaga tandja algatusel, aruandekuu lpul','03',0,0);
  set ldc_1=null;
  select v1 into ldc_1 from gl_pa_stat where gl_pa_stat."id"=3;
  if ldc_1 is not null then
    update gl_pa_stat set v1=ldc_1+v2+v3 where id=2;
  end if;
  -- tootatud tunnid
  insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 5,'Ttatud tundide arv (tuhandetes tundides kahe kmnendkohaga)','04',
             Round(sum(if gl_list.id1=1 then get_normtundi_paevas(gl_list."id",ld_perlop)*get_tp_arv_tool(gl_list.kuup1,gl_list.kuup2,gl_list."id") else 0 endif)/1000,2) as a_v2,
             Round(sum(if gl_list.id1=4 then get_normtundi_paevas(gl_list."id",ld_perlop)*get_tp_arv_tool(gl_list.kuup1,gl_list.kuup2,gl_list."id") else 0 endif)/1000,2) as a_v3,
             a_v2+a_v3
      from gl_list;
  -- tasud
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 6,
             ''Tasu tegelikult ttatud aja eest (eurodes)'',
             ''05'',
             Round(sum(if gl_list.id1=1 then pa_tasu.summa else 0 endif),0) as a_v2,
             Round(sum(if gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3,
             a_v2+a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and Left(pa_taslist.statkood,2)=''05''';
  execute immediate ls_insert;
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 7,
             ''Tasu mittettatud aja eest (eurodes)'',
             ''06'',
             Round(sum(if gl_list.id1=1 then pa_tasu.summa else 0 endif),0) as a_v2,
             Round(sum(if gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3,
             a_v2+a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and Left(pa_taslist.statkood,2)=''06''';
  execute immediate ls_insert;
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 8,
             ''Tandja hvitis haigestumise, tnnetuse ja kutsehaiguse puhul (eurodes)'',
             ''07'',
             Round(sum(if gl_list.id1=1 then pa_tasu.summa else 0 endif),0) as a_v2,
             Round(sum(if gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3,
             a_v2+a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and Left(pa_taslist.statkood,2)=''07''';
  execute immediate ls_insert;
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 9,
             ''Ttajatele vljamakstav tasu (eurodes)'',
             ''08'',
             Round(sum(if gl_list.id1=1 then pa_tasu.summa-pa_tasu.tulumaks-pa_tasu.tvtkmaks-pa_tasu.pensmaks else 0 endif),0) as a_v2,
             Round(sum(if gl_list.id1=4 then pa_tasu.summa-pa_tasu.tulumaks-pa_tasu.tvtkmaks-pa_tasu.pensmaks else 0 endif),0) as a_v3,
             a_v2+a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and Left(pa_taslist.statkood,2) in (''05'',''06'')';
  execute immediate ls_insert;
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 10,
             ''Ttajate keskmine arv, taandatud tistajale (kahe kmnendkohaga)'',
             ''09'',
             Round(sum(if gl_list.id1=1 then get_kp_arv_toolpuhk_pta(gl_list.kuup1,gl_list.kuup2,gl_list."id")*gl_list.sum1 else 0 endif)/ldc_kpa_kuus_pta,2) as a_v2,
             Round(sum(if gl_list.id1=4 then get_kp_arv_toolpuhk_pta(gl_list.kuup1,gl_list.kuup2,gl_list."id")*gl_list.sum1 else 0 endif)/ldc_kpa_kuus_pta,2) as a_v3,
             a_v2+a_v3
      from gl_list';
  execute immediate ls_insert;
  -- Ebaregulaarne preemia
  insert into gl_pa_stat("id",nimi,kood) values (11,'Ebaregulaarne preemia ja lisatasu - kvartalipreemia, aastapreemia, julupreemia jm lisatasud','X2');
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 12,
             ''Real 05 nidatud ebaregulaarne preemia, lisatasu (eurodes)'',
             ''10'',
             Round(sum(if gl_list.id1=1 then pa_tasu.summa else 0 endif),0) as a_v2,
             Round(sum(if gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3,
             a_v2+a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and Left(pa_taslist.statkood,4)=''0510''';
  execute immediate ls_insert;
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 13,
             ''Real 06 nidatud ebaregulaarne preemia, lisatasu (eurodes)'',
             ''11'',
             Round(sum(if gl_list.id1=1 then pa_tasu.summa else 0 endif),0) as a_v2,
             Round(sum(if gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3,
             a_v2+a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and Left(pa_taslist.statkood,4)=''0611''';
  execute immediate ls_insert;
  -- Mitterahaline tasu
  insert into gl_pa_stat("id",nimi,kood) values (14,'Mitterahaline tasu (loonustasu)','X3');
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 15,
             ''Real 06 nidatud mitterahaline tasu (eurodes)'',
             ''12'',
             Round(sum(if gl_list.id1=1 then pa_tasu.summa else 0 endif),0) as a_v2,
             Round(sum(if gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3,
             a_v2+a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and Left(pa_taslist.statkood,4)=''0612''';
  execute immediate ls_insert;
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v1)
      select 16,
             ''Kaudsed toetused ttajatele: soodustused tle ja tlt koju siduks; dotatsioon sklatele, sgitalongid (vauterid) jm -- ei nidata real 06 (eurodes)'',
             ''13'',
             Round(sum(if gl_list.id1=1 or gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and Left(pa_taslist.statkood,2)=''13''';
  execute immediate ls_insert;
  -- Hoiuskeemid
  insert into gl_pa_stat("id",nimi,kood) values (17,'Tandja makse ttajate jaoks loodud hoiuskeemidesse','X4');
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v1)
      select 18,
             ''Tandja makse ttajate jaoks loodud hoiuskeemidesse (tandja hoiuskeemid, aktsiate ostmise skeemid jt) -- ei nidata real 06 (eurodes)'',
             ''14'',
             Round(sum(if gl_list.id1=1 or gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and Left(pa_taslist.statkood,2)=''14''';
  execute immediate ls_insert;
  -- Hyvitised ja toetused
  insert into gl_pa_stat("id",nimi,kood) values (19,'Tandja hvitised ja sotsiaaltoetused ttajatele','X5');
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 20,
             ''Real 06 nidatud tandja poolt t mitteandmisel vi ttamise takistuse korral makstav keskmine ttasu (eurodes)'',
             ''15'',
             Round(sum(if gl_list.id1=1 then pa_tasu.summa else 0 endif),0) as a_v2,
             Round(sum(if gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3,
             a_v2+a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and Left(pa_taslist.statkood,4)=''0615''';
  execute immediate ls_insert;
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v1)
      select 21,
             ''Hvitised tsuhte lpetamisel. Tandja toetused arstiabi kasutamise korral; lapsehoolduspuhkusel viibivatele ttajatele; tandja juures ttanud endistele ttajatele; hekordne toetus juubeli, snni ja surma puhul; stipendiumid ja ppemaksud jm - ei nidata ridadel 05 ja 06 (eurodes)'',
             ''16'',
             Round(sum(if gl_list.id1=1 or gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and Left(pa_taslist.statkood,2)=''16''';
  execute immediate ls_insert;
  -- Muud saadud toetused
  insert into gl_pa_stat("id",nimi,kood) values (22,'Muudelt organisatsioonidelt saadud toetused tandjale','X6');
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 23,
             ''Real 05 nidatud tandjale makstav tturutoetus, mis on ette nhtud ttasu maksmiseks ttu tle rakendamisel (eurodes)'',
             ''17'',
             Round(sum(if gl_list.id1=1 then pa_tasu.summa else 0 endif),0) as a_v2,
             Round(sum(if gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3,
             a_v2+a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and Left(pa_taslist.statkood,4)=''0517''';
  execute immediate ls_insert;
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v2,v3,v1)
      select 24,
             ''Real 05 nidatud sihtannetuste arvelt oma ttajatele makstav brutotasu (eurodes)'',
             ''18'',
             Round(sum(if gl_list.id1=1 then pa_tasu.summa else 0 endif),0) as a_v2,
             Round(sum(if gl_list.id1=4 then pa_tasu.summa else 0 endif),0) as a_v3,
             a_v2+a_v3
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and Left(pa_taslist.statkood,4)=''0518''';
  execute immediate ls_insert;
  -- Sotsiaalkindlustusskeemid
  insert into gl_pa_stat("id",nimi,kood) values (25,'Tandja kohustuslikud, leppekohased ja vabatahtlikud maksed sotsiaalkindlustusskeemidesse','X7');
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v1)
      select 26,
             ''Sotsiaalmaks (33%) (eurodes)'',
             ''19'',
            Round(sum(if gl_list.id1=1 or gl_list.id1=4 then (if pa_taslist.sisse=0 then pa_tasu.sotsmaks else -1*pa_tasu.sotsmaks endif) else 0 endif),0) as a_v3
       from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood;
  execute immediate ls_insert;
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v1)
      select 27,
             ''Tandja ttuskindlustusmakse (eurodes)'',
             ''20'',
            Round(sum(if gl_list.id1=1 or gl_list.id1=4 then (if pa_taslist.sisse=0 then pa_tasu.tatkmaks else -1*pa_tasu.tatkmaks endif) else 0 endif),0) as a_v3
       from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood;
  execute immediate ls_insert;
  insert into gl_pa_stat("id",nimi,kood,v1) values (28,'Tandja leppekohased ja vabatahtlikud maksed (eurodes)','21',0);
  -- Toovotulepingud
  insert into gl_pa_stat("id",nimi,kood) values (29,'1.2 Tvtulepinguga ttavad isikud, kelle ttasudelt maksab sotsiaalmaksu tandja','X8');
  insert into gl_pa_stat("id",nimi,kood,v1)
      select 30,
             'Tvtulepinguga ttajate arv aruandekuu lpul',
             '22',
             count(if gl_list.id1=3 then gl_list.id1 else null endif)
      from gl_list
      where gl_list.kuup2=ld_perlop and pa_peat_lapsehp(ld_perlop,gl_list."id")=0;
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v1)
      select 31,
             ''Tvtulepinguga ttajate ttasu (eurodes)'',
             ''23'',
             Round(sum(if gl_list.id1=3 then pa_tasu.summa else 0 endif),0)
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood + ' and pa_taslist.sisse=0 and pa_taslist.smrk=1';
  execute immediate ls_insert;
  insert into gl_pa_stat("id",nimi,kood,v1)
      select 32,'Tvtulepinguga ttajate ttatud tundide arv (tuhandetes tundides kahe kmnendkohaga)','24',
             Round(sum(if gl_list.id1=3 then get_normtundi_paevas(gl_list."id",ld_perlop)*get_tp_arv_tool(gl_list.kuup1,gl_list.kuup2,gl_list."id") else 0 endif)/1000,2)
      from gl_list;
  insert into gl_pa_stat("id",nimi,kood,v1)
      select 33,
             'Tvtulepinguga ttajate keskmine arv, taandatud tistajale (kahe kmnendkohaga)',
             '25',
             Round(sum(if gl_list.id1=3 then get_kp_arv_toolpuhk_pta(gl_list.kuup1,gl_list.kuup2,gl_list."id")*gl_list.sum1 else 0 endif)/ldc_kpa_kuus_pta,2)
      from gl_list;
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v1)
      select 34,
             ''Tvtulepinguga ttajate ttasudelt arvestatud sotsiaalmaks (33%) (eurodes)'',
             ''26'',
            Round(sum(if gl_list.id1=3 then (if pa_taslist.sisse=0 then pa_tasu.sotsmaks else -1*pa_tasu.sotsmaks endif) else 0 endif),0)
       from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood;
  execute immediate ls_insert;
  set ls_insert='insert into gl_pa_stat("id",nimi,kood,v1)
      select 35,
             ''Tvtulepinguga ttajate ttasudelt arvestatud tandja ttuskindlustusmakse (eurodes)'',
             ''27'',
            Round(sum(if gl_list.id1=3 then (if pa_taslist.sisse=0 then pa_tasu.tatkmaks else -1*pa_tasu.tatkmaks endif) else 0 endif),0)
       from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list.id left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
      where ' + ls_periood;
  execute immediate ls_insert;
  -- nullid
  update gl_pa_stat set v1=0 where v1 is null and gl_pa_stat."id" in (2,3,4,5,6,7,8,9,10,12,13,15,16,18,20,21,23,24,26,27,28,30,31,32,33,34,35);
  update gl_pa_stat set v2=0 where v2 is null and gl_pa_stat."id" in (2,5,6,7,8,9,10,12,13,15,20,23,24);
  update gl_pa_stat set v3=0 where v3 is null and gl_pa_stat."id" in (2,4,5,6,7,8,9,10,12,13,15,20,23,24)
END