CREATE PROCEDURE "DBA"."pa_stat_strukt"( in a_skoopkood char(16), in a_skoop integer, in a_yksuskood char(16), in a_yksusnr integer, in a_a_akuu numeric(2), in a_a_aasta char(4), in a_statnr integer default 0)
BEGIN
  declare ld_peralg date;
  declare ld_perlop date;
  declare ld_astalg date;
  declare ld_astlop date;
  declare ldc_tpa_kuus decimal(15,2);
  declare ldc_kpa_kuus_pta decimal(15,2);
  declare ldc_1 decimal(15,2);
  declare ldc_2 decimal(15,2);
  declare ldc_3 decimal(15,2);
  declare ls_productversion char(100);
  set ld_peralg=ymd(a_a_aasta,a_a_akuu,1);
  set ld_perlop=get_perlop(ymd(a_a_aasta,a_a_akuu,28));
  set ld_astalg=ymd(a_a_aasta,1,1);
  set ld_astlop=ymd(a_a_aasta,12,31);
  set ldc_tpa_kuus=get_tp_arv_per(ld_peralg,ld_perlop);
  set ldc_kpa_kuus_pta=get_kp_arv_per_pta(ld_peralg,ld_perlop);
  delete from gl_tr_universal;
  delete from gl_tr_universal2;
  delete from gl_list;
  -- kuup1 - toolepingu alguse kuupaev
  -- kuup2 - aasta esimene toopaev
  -- kuup3 - kuu esimene toopaev
  -- kuup4 - kuu viimane toopaev
  -- kuup5 - aasta viimane toopaev
  -- ld_peralg ld_perlop - kuu esimene ja viimane pev
  -- ld_astalg ld_astlop - aasta esimene ja viimane pev
  insert into gl_list("id","id1","sum1","kuup1","kuup2","kuup3","kuup4","kuup5")
    select distinct pa_leping.lepnr,
                    pa_leping.id_koht,
                    get_pa_leping_tun_koht(pa_leping.lepnr,ld_perlop) as pa_leping_tun_koht,
                    pa_leping.kuup1,
                    if pa_leping.kuup1>ld_astalg then pa_leping.kuup1 else ld_astalg endif,
                    if pa_leping.kuup1>ld_peralg then pa_leping.kuup1 else ld_peralg endif,
                    if pa_leping.kuup2 is null or pa_leping.kuup2>ld_perlop then ld_perlop else pa_leping.kuup2 endif,
                    if pa_leping.kuup2 is null or pa_leping.kuup2>ld_astlop then ld_astlop else pa_leping.kuup2 endif
    from pa_leping left outer join pa_isik on pa_leping.lepnr = pa_isik.lepnr
                   left outer join pa_yksus on pa_isik.yksusnr = pa_yksus.yksusnr
                   left outer join skoobid on pa_yksus.skoop=skoobid.skoop
                   left outer join pa_tasu on pa_isik.lepnr=pa_tasu.lepnr and pa_isik.yksusnr=pa_tasu.yksusnr
                   left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
    where (pa_yksus.skoop = a_skoop or a_skoop = 0) and "Left"(skoobid.kood,Length(a_skoopkood))=a_skoopkood and
          (pa_isik.yksusnr = a_yksusnr or a_yksusnr = 0) and "Left"(pa_yksus.kood,Length(a_yksuskood))=a_yksuskood and
          (pa_yksus.statnr = a_statnr or a_statnr = 0) and
          (pa_leping.id_koht=1 or pa_leping.id_koht=4) and
          pa_tasu.a_aasta=a_a_aasta and pa_tasu.a_akuu=a_a_akuu and pa_tasu.summa>0 and pa_taslist.sisse=0 and pa_taslist.algol not in ('1b','1d','1h','1i','1k','1l','1o','1p','1r','1s','1t');

  -- 8-nadala norm; 9-tootunnid; 11-puhkusepaevad; 18-kuud; 19-toopaevad; 20-puhkusepaevad
  insert into gl_tr_universal2("id",sum5,sum8,sum9,sum11,sum18,sum19,sum20)
    select gl_list."id",
           Floor((datediff(month,gl_list.kuup1,gl_list.kuup5)-1+cast(datediff(day,gl_list.kuup1,get_perlop(gl_list.kuup1))+datediff(day,get_peralg(gl_list.kuup5),gl_list.kuup5)+2 as decimal(20,3))/(cast(datediff(day,get_peralg(gl_list.kuup2),get_perlop(gl_list.kuup2))+datediff(day,get_peralg(gl_list.kuup5),get_perlop(gl_list.kuup5))+2 as decimal(20,3))/2))/12),
           get_tundi_nadalas(gl_list."id"),
           Round(get_tundi_paevas(gl_list."id",ldc_tpa_kuus)*get_tp_arv_tool(gl_list.kuup3,gl_list.kuup4,gl_list."id"),2),
           get_kp_arv_puhk(ld_peralg,ld_perlop,gl_list."id"),
           Round(datediff(month,gl_list.kuup2,gl_list.kuup5)-1+cast(datediff(day,gl_list.kuup2,get_perlop(gl_list.kuup2))+datediff(day,get_peralg(gl_list.kuup5),gl_list.kuup5)+2 as decimal(20,3))/(cast(datediff(day,get_peralg(gl_list.kuup2),get_perlop(gl_list.kuup2))+datediff(day,get_peralg(gl_list.kuup5),get_perlop(gl_list.kuup5))+2 as decimal(20,3))/2),1),
           get_tp_arv_tool(gl_list.kuup2,gl_list.kuup5,gl_list."id"),
           get_kp_arv_puhk(ld_astalg,ld_astlop,gl_list."id")
      from gl_list;

   
  -- pohitootasu kuus, yletunnid
  insert into gl_tr_universal2("id",sum13,sum10,sum14,sum15)
    select pa_tasu.lepnr,
             sum(pa_tasu.summa),
             sum(if pa_taslist.statrida=6 then pa_tasu.par1 else 0 endif),
             sum(if pa_taslist.statrida=6 then pa_tasu.summa else 0 endif),
             sum(if pa_taslist.statrida=7 then pa_tasu.summa else 0 endif)
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list."id"
                   left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
                   left outer join pa_yksus on pa_tasu.yksusnr = pa_yksus.yksusnr 
                   left outer join skoobid on pa_yksus.skoop=skoobid.skoop
      where (pa_yksus.skoop = a_skoop or a_skoop = 0) and
            "Left"(skoobid.kood,Length(a_skoopkood))=a_skoopkood and
            "Left"(pa_yksus.kood,Length(a_yksuskood))=a_yksuskood and
            (pa_tasu.yksusnr = a_yksusnr or a_yksusnr = 0) and
            (pa_yksus.statnr = a_statnr or a_statnr = 0) and
            gl_list."id" is not null and
            pa_tasu.a_aasta=a_a_aasta and pa_tasu.a_akuu=a_a_akuu and pa_taslist.sisse=0 and pa_taslist.statrida in (5,6,7)
      group by pa_tasu.lepnr;

  -- Mittettatud pevad, tasu kuus, tasu aastas
  insert into gl_tr_universal2("id",sum12,sum17,sum21)
    select pa_tasu.lepnr,
             sum(if pa_tasu.a_akuu=a_a_akuu then pa_tasu.par1 else 0 endif),
             sum(if pa_tasu.a_akuu=a_a_akuu then pa_tasu.summa else 0 endif),
             sum(pa_tasu.par1)
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list."id"
                   left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
                   left outer join pa_yksus on pa_tasu.yksusnr = pa_yksus.yksusnr 
                   left outer join skoobid on pa_yksus.skoop=skoobid.skoop
      where (pa_yksus.skoop = a_skoop or a_skoop = 0) and
            "Left"(skoobid.kood,Length(a_skoopkood))=a_skoopkood and
            "Left"(pa_yksus.kood,Length(a_yksuskood))=a_yksuskood and
            (pa_tasu.yksusnr = a_yksusnr or a_yksusnr = 0) and
            (pa_yksus.statnr = a_statnr or a_statnr = 0) and
            gl_list."id" is not null and
            pa_tasu.a_aasta=a_a_aasta and pa_taslist.sisse=0 and pa_taslist.statrida=9
      group by pa_tasu.lepnr;

  -- puhkuse tasu kuus
  insert into gl_tr_universal2("id",sum16)
      select pa_tasu.lepnr,
             sum(pa_tasu.summa)
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list."id"
                   left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
                   left outer join pa_yksus on pa_tasu.yksusnr = pa_yksus.yksusnr 
                   left outer join skoobid on pa_yksus.skoop=skoobid.skoop
      where (pa_yksus.skoop = a_skoop or a_skoop = 0) and
            "Left"(skoobid.kood,Length(a_skoopkood))=a_skoopkood and
            "Left"(pa_yksus.kood,Length(a_yksuskood))=a_yksuskood and
            (pa_tasu.yksusnr = a_yksusnr or a_yksusnr = 0) and
            (pa_yksus.statnr = a_statnr or a_statnr = 0) and
            gl_list.id is not null and
            pa_tasu.a_aasta=a_a_aasta and pa_tasu.a_akuu=a_a_akuu and pa_taslist.sisse=0 and pa_taslist.statrida=10
      group by pa_tasu.lepnr;
  
  -- pohitootasu aastas
  insert into gl_tr_universal2("id",sum23,sum24)
      select pa_tasu.lepnr,
             sum(pa_tasu.summa),
             sum(if pa_taslist.statrida=8 then pa_tasu.summa else 0 endif)
      from pa_tasu left outer join gl_list on pa_tasu.lepnr=gl_list."id"
                   left outer join pa_taslist on pa_tasu.tas_s=pa_taslist.tas_s
                   left outer join pa_yksus on pa_tasu.yksusnr = pa_yksus.yksusnr 
                   left outer join skoobid on pa_yksus.skoop=skoobid.skoop
      where (pa_yksus.skoop = a_skoop or a_skoop = 0) and
            "Left"(skoobid.kood,Length(a_skoopkood))=a_skoopkood and
            "Left"(pa_yksus.kood,Length(a_yksuskood))=a_yksuskood and
            (pa_tasu.yksusnr = a_yksusnr or a_yksusnr = 0) and
            (pa_yksus.statnr = a_statnr or a_statnr = 0) and
            gl_list.id is not null and
            pa_tasu.a_aasta=a_a_aasta and pa_taslist.sisse=0 and pa_taslist.statrida in (5,6,7,8)
      group by pa_tasu.lepnr;

  -- kokku leping
  insert into gl_tr_universal("id",sum5,sum8,sum9,sum10,sum11,sum12,sum13,sum14,sum15,sum16,sum17,sum18,sum19,sum20,sum21,sum23,sum24)
    select "id",sum(sum5),sum(sum8),sum(sum9),sum(sum10),sum(sum11),sum(sum12),sum(sum13),sum(sum14),sum(sum15),sum(sum16),sum(sum17),sum(sum18),sum(sum19),sum(sum20),sum(sum21),sum(sum23),sum(sum24)
      from gl_tr_universal2
      group by gl_tr_universal2."id"
  
  
END