CREATE FUNCTION "DBA"."pl_tarif_summa"( in a_tarifnr integer )
RETURNS decimal(15,2)
BEGIN
  declare ldc_summa decimal(15,2);
  select Round(pl_tarif.koht/ntlist.nt*klasslist.palk,2) into ldc_summa
    from pl_tarif left outer join pl_tookad on pl_tarif.tookid=pl_tookad.tookid left outer join klasslist on pl_tarif.klassnr=klasslist.klassnr left outer join ntlist on pl_tookad.ntt=ntlist.ntt
    where pl_tarif.tarifnr=a_tarifnr;
  if ldc_summa is null then
    set ldc_summa=0;
  end if;
  return ldc_summa;
END