ALTER PROCEDURE "dba"."pr_kan_update"( in a_skoop integer,in peralg date,in perlop date,in a_id_prog smallint)
BEGIN
  declare ll_id integer;
  declare li_aasta smallint;
  declare ld_kuup date;
  declare ldc_summa numeric(15,2);
  declare ls_doknr char(20);
  declare ls_tulnud char(100);
  declare ls_info char(200);
  declare ls_order char(3);
  declare ls_deeb char(7);
  declare ls_kree char(7);
  declare ll_partnr integer;
  declare ll_partnr2 integer;
  declare ll_asutnr integer;
  declare ll_meetnr integer;
  declare ll_kulnr integer;
  declare ll_talnr integer;
  declare ll_artnr integer;
  declare ll_tulnr integer;
  declare ll_objectnr integer;
  declare ll_osaknr integer;
  declare ll_subjectnr integer;
  declare ll_suundnr integer;
  declare ll_taotnr integer;
  declare ll_alliknr integer;
  declare ll_ravonr integer;
  declare err_notfound exception for sqlstate value '02000';
  declare c_gl_pr_kanne_update dynamic scroll cursor for select "id","aasta",kuup,summa+summa_orig,"info","order",deeb,kree,partnr,partnr2,asutnr,meetnr,kulnr,talnr,tulnr,artnr,objectnr,osaknr,subjectnr,suundnr,taotnr,alliknr,ravonr from gl_pr_kanne_update where summa<>0;
  delete from gl_pr_kanne_import;
  delete from gl_pr_kanne_update;
  -- pearaamatu kanded koos id ja aasta
  insert into gl_pr_kanne_import("id",aasta,kuup,summa,summa_orig,"info","order",deeb,kree,partnr,partnr2,asutnr,meetnr,kulnr,talnr,tulnr,artnr,objectnr,osaknr,subjectnr,suundnr,taotnr,alliknr,ravonr)
    select "id","aasta",kuup,(-1)*summa,summa,"info","order",deeb,kree,partnr,partnr2,asutnr,meetnr,kulnr,talnr,tulnr,artnr,objectnr,osaknr,subjectnr,suundnr,taotnr,alliknr,ravonr
      from pr_kanne
      where pr_kanne.skoop=a_skoop and (pr_kanne.kuup>=peralg) and(pr_kanne.kuup<=perlop) and pr_kanne.id_prog=a_id_prog;
  -- mooduli kanded ilma id ja aasta
  insert into gl_pr_kanne_import("id",aasta,kuup,summa,summa_orig,"info","order",deeb,kree,partnr,partnr2,asutnr,meetnr,kulnr,talnr,tulnr,artnr,objectnr,osaknr,subjectnr,suundnr,taotnr,alliknr,ravonr)
    select 0,0,kuup,summa,0,"info","order",deeb,kree,partnr,partnr2,asutnr,meetnr,kulnr,talnr,tulnr,artnr,objectnr,osaknr,subjectnr,suundnr,taotnr,alliknr,ravonr
      from gl_pr_kanne where skoop=a_skoop;
  -- summeeri sarnased kokku ja vali yks id ja aasta
  insert into gl_pr_kanne_update("id",aasta,kuup,summa,summa_orig,"info","order",deeb,kree,partnr,partnr2,asutnr,meetnr,kulnr,talnr,tulnr,artnr,objectnr,osaknr,subjectnr,suundnr,taotnr,alliknr,ravonr)
    select max("id"),max("aasta"),kuup,sum(summa),sum(summa_orig),"info","order",deeb,kree,partnr,partnr2,asutnr,meetnr,kulnr,talnr,tulnr,artnr,objectnr,osaknr,subjectnr,suundnr,taotnr,alliknr,ravonr
      from gl_pr_kanne_import
      group by kuup,"info","order",deeb,kree,partnr,partnr2,asutnr,meetnr,kulnr,talnr,tulnr,artnr,objectnr,osaknr,subjectnr,suundnr,taotnr,alliknr,ravonr;
-- kui summa<>0, siis midagi on muutunud - kandeid muudetakse
-- kui id=0, siis varem pole - kanne lisatakse
-- kui summa+summa_orig=0, siis neid kandeid ei pea olema - kanded kustutatakse
-- kui summa+summa_orig<>0, siis kanne on muutunud - kanne korrastatakse
  case a_id_prog when 1 then
    set ls_tulnud='Kassa/pank';
  when 2 then
    set ls_tulnud='Arveldused';
  when 5 then
    set ls_tulnud='Palk';
  when 6 then
    set ls_tulnud='Pohivarad';
  when 7 then
    set ls_tulnud='Materjalid';
  end case;
  set ls_doknr=get_doknr_pr(years(perlop),a_skoop);
  open c_gl_pr_kanne_update;
  gl_pr_kanne_update: loop
    fetch next c_gl_pr_kanne_update into ll_id,li_aasta,ld_kuup,ldc_summa,ls_info,ls_order,ls_deeb,ls_kree,ll_partnr,ll_partnr2,ll_asutnr,ll_meetnr,ll_kulnr,ll_talnr,ll_tulnr,ll_artnr,ll_objectnr,ll_osaknr,ll_subjectnr,ll_suundnr,ll_taotnr,ll_alliknr,ll_ravonr;
    if sqlstate = err_notfound then -- kui eof
      leave gl_pr_kanne_update
    end if;
    if ll_id=0 then
      insert into pr_kanne(doknr,tulnud,id_prog,kuup,summa,"info","order",deeb,partnr,kree,partnr2,meetnr,kulnr,talnr,artnr,tulnr,objectnr,osaknr,subjectnr,suundnr,taotnr,alliknr,ravonr,asutnr,skoop,user_code)
        values (ls_doknr,ls_tulnud,a_id_prog,ld_kuup,ldc_summa,ls_info,ls_order,ls_deeb,ll_partnr,ls_kree,ll_partnr2,ll_meetnr,ll_kulnr,ll_talnr,ll_artnr,ll_tulnr,ll_objectnr,ll_osaknr,ll_subjectnr,ll_suundnr,ll_taotnr,ll_alliknr,ll_ravonr,ll_asutnr,a_skoop,32767)
    else
      if ldc_summa=0 then
        delete from pr_kanne where id=ll_id and aasta=li_aasta
      else
        update pr_kanne set kuup=ld_kuup,summa=ldc_summa,"info"=ls_info,"order"=ls_order,deeb=ls_deeb,kree=ls_kree,partnr=ll_partnr,partnr2=ll_partnr2,asutnr=ll_asutnr,meetnr=ll_meetnr,kulnr=ll_kulnr,talnr=ll_talnr,tulnr=ll_tulnr,artnr=ll_artnr,objectnr=ll_objectnr,osaknr=ll_osaknr,subjectnr=ll_subjectnr,suundnr=ll_suundnr,taotnr=ll_taotnr,alliknr=ll_alliknr,ravonr=ll_ravonr where id=ll_id and aasta=li_aasta
      end if
    end if
  end loop gl_pr_kanne_update;
  close c_gl_pr_kanne_update;
  -- kustuta pearaamatu kanded, mis ei lbinud analyysi - sarnased kanded mitte max
  delete from gl_pr_kanne_import from gl_pr_kanne_import left outer join gl_pr_kanne_update on gl_pr_kanne_import."id"=gl_pr_kanne_update."id" and gl_pr_kanne_import."aasta"=gl_pr_kanne_update."aasta" where gl_pr_kanne_import."id"=0 or gl_pr_kanne_update."id" is not null;
  set ll_id=0;
  select count() into ll_id from gl_pr_kanne_import;
  if ll_id>0 then
    delete from pr_kanne from pr_kanne left outer join gl_pr_kanne_import on pr_kanne."id"=gl_pr_kanne_import."id" and pr_kanne.aasta=gl_pr_kanne_import.aasta where pr_kanne.skoop=a_skoop and (pr_kanne.kuup>=peralg) and(pr_kanne.kuup<=perlop) and pr_kanne.id_prog=a_id_prog and gl_pr_kanne_import."id" is not null;
  end if;
  -- kustuta muudatuse fikseerimine
  delete from pr_import where kuu=month(perlop) and aasta=years(perlop) and skoop=a_skoop and id_prog=a_id_prog
END