ALTER PROCEDURE "DBA"."pv_koond1_nimekiri2"( in a_skoop integer,in a_yksusnr integer,in a_yksuskood char(16),in a_paring integer,in a_perlop date)
BEGIN
  declare ls_konto char(7);
  declare ls_toot_nr char(20);
  declare ls_vara_nr char(10);
  declare ls_nimi char(100);
  declare ls_yldnimi char(200);
  declare ld_kuup date;
  declare ld_ekspl date;
  declare ldc_summa numeric(15,2);
  declare ldc_kogus numeric(15,3);
  declare ldc_epk decimal(15,2);
  declare ldc_jpk1 decimal(15,2);
  declare ldc_jpk2 decimal(15,2);
  declare ldc_jpk decimal(15,2);
  declare ldc_piir_min decimal(15,2);
  declare ldc_piir_max decimal(15,2);
  declare ldc_kulu_p numeric(10,3);
  declare li_yksusnr integer;
  declare li_yldnimnr integer;
  declare li_id integer;
  declare li_id_min integer;
  declare li_paring integer;
  declare err_notfound exception for sqlstate value '02000';
  declare c_pv_kanne dynamic scroll cursor for
        select pv_kanne.id,
               pv_kanne.yldnimnr,
               pv_kanne.yksusnr,
               pv_yksus.konto,
               if pv_kanne.toot_nr is null then '' else trim(pv_kanne.toot_nr) endif,
               pv_kanne.vara_nr,
               pv_kanne.nimi,
               if pv_kanne_muuinfo.yldnimi is null or Trim(pv_kanne_muuinfo.yldnimi)='' then pv_kanne.nimi else pv_kanne_muuinfo.yldnimi endif,
               get_pv_protsent("pv_kanne"."id",years(a_perlop),month(a_perlop)),
               pv_kanne.kuup,
               pv_kanne.ekspl,
               if pv_kanne.kogus is null then 1 else pv_kanne.kogus endif,
               pv_kanne.alg_m,
               pv_epk(pv_kanne.id,years(a_perlop)) as epk,
               pv_jpk(pv_kanne.id,years(a_perlop),month(a_perlop)-1,epk)+(if years(pv_kanne.kuup)=years(a_perlop) and pv_kanne.kuup<ymd(Years(a_perlop),Month(a_perlop),1) then pv_kanne.ytk else 0 endif) as jpk1,
               pv_jpk(pv_kanne.id,years(a_perlop),month(a_perlop),epk)+(if years(pv_kanne.kuup)=years(a_perlop) and pv_kanne.kuup<ymd(Years(a_perlop),Month(a_perlop)+1,1) then pv_kanne.ytk else 0 endif) as jpk2
             from pv_kanne left outer join gl_1 on(pv_kanne.id = gl_1.id) and(pv_kanne.kuup = gl_1.kuup)
                           left outer join pv_yksus on pv_kanne.yksusnr = pv_yksus.yksusnr
                           left outer join pv_kanne_muuinfo on pv_kanne.yldnimnr=pv_kanne_muuinfo.id
             where((pv_kanne.id = gl_1.id) and(pv_kanne.kuup = gl_1.kuup) or a_paring = 0) and(pv_yksus.skoop = a_skoop or a_skoop = 0) and(pv_kanne.yksusnr = a_yksusnr or a_yksusnr = 0) and Left(pv_yksus.kood,Length(a_yksuskood))=a_yksuskood and pv_kanne.kuup <= a_perlop and(pv_kanne.objnr2 is null)
             order by "pv_kanne"."id" asc;
  delete from gl_pv_kanne;
  select "tr_nim_piir_min","tr_nim_piir_max" into ldc_piir_min,ldc_piir_max from "pv_konfm" where "id"=1;
  set li_paring=set_gl_1(a_paring);
  open c_pv_kanne;
  pv_kanne_loop: loop
    fetch next c_pv_kanne into li_id,li_yldnimnr,li_yksusnr,ls_konto,ls_toot_nr,ls_vara_nr,ls_nimi,ls_yldnimi,ldc_kulu_p,ld_kuup,ld_ekspl,ldc_kogus,ldc_summa,ldc_epk,ldc_jpk1,ldc_jpk2;
    if sqlstate = err_notfound then -- kui eof
      leave pv_kanne_loop
    end if;
    -- korduv kanne
    set li_id_min=null;
    if li_yldnimnr is not null then
      select first id into li_id_min from gl_pv_kanne where yldnimnr=li_yldnimnr;
    else
      if Length(ls_toot_nr)>0 then
        select first id into li_id_min from gl_pv_kanne where toot_nr=ls_toot_nr
      end if;
    end if;
    -- kui detailne vi esimene kanne
    if li_id_min is null then
      insert into gl_pv_kanne( id,yldnimnr,yksusnr,konto,toot_nr,vara_nr,nimi,yldnimi,kulu_p,kuup,ekspl,kogus,alg_m,epk,jpk2)
                       values( li_id,li_yldnimnr,li_yksusnr,ls_konto,ls_toot_nr,ls_vara_nr,ls_nimi,ls_yldnimi,ldc_kulu_p,ld_kuup,ld_ekspl,ldc_kogus,ldc_summa,ldc_epk,ldc_jpk2);
    else
      update gl_pv_kanne set alg_m=alg_m+ldc_summa,epk=epk+ldc_epk,jpk2=jpk2+ldc_jpk2 where gl_pv_kanne.id=li_id_min;
    end if
  end loop pv_kanne_loop;
  close c_pv_kanne;
  -- kustutamine
  delete from gl_pv_kanne where alg_m<ldc_piir_min or alg_m>=ldc_piir_max;
END