ALTER PROCEDURE "DBA"."pv_koond_inv"(in a_skoop integer,in a_yksusnr integer,in a_yksuskood char(16),in a_asutnr integer,in a_paring integer,in a_kuup date, in a_id_user integer)
begin
  declare ls_konto char(7);
  declare ls_toot_nr char(20);
  declare ls_vara_nr char(10);
  declare ls_nimi char(100);
  declare ls_yldnimi char(200);
  declare ls_info char(250);
  declare ls_tunnus char(250);
  declare ls_info3 char(100);
  declare ld_invkuup date;
  declare li_tegelik smallint;
  declare li_raamat smallint;
  declare li_invent integer;
  declare li_kulunud smallint;
  declare li_info smallint;
  declare li_tunnus smallint;
  declare ld_invent timestamp;
  declare ld_kuup date;
  declare ld_ekspl date;
  declare ldc_summa numeric(15,2);
  declare ldc_raamat_summa numeric(15,2);
  declare ldc_teg_summa numeric(15,2);
  declare ldc_kogus numeric(15,3);
  declare ldc_raamat_kogus numeric(15,3);
  declare ldc_teg_kogus numeric(15,3);
  declare ldc_epk decimal(15,2);
  declare ldc_jpk1 decimal(15,2);
  declare ldc_jpk2 decimal(15,2);
  declare ldc_jpk decimal(15,2);
  declare ldc_mjm decimal(15,2);
  declare ldc_kulu_p numeric(10,3);
  declare li_kulunud_k numeric(2);
  declare li_kulunud_a numeric(4);
  declare li_kuid integer;
  declare li_yksusnr integer;
  declare li_id integer;
  declare li_yldnimnr integer;
  declare li_id_min integer;
  declare li_detinv smallint;
  declare li_inv_markus smallint;
  declare li_inv_vara2 smallint;
  declare li_paring integer;
  declare err_notfound exception for sqlstate value '02000';
  declare c_pv_kanne dynamic scroll cursor for
        select pv_kanne.id,
        pv_kanne.yldnimnr,
        pv_kanne.yksusnr,
        pv_yksus.konto,
        if pv_kanne.toot_nr is null then '' else trim(pv_kanne.toot_nr) endif,
        pv_kanne.vara_nr,
        pv_kanne.nimi,
        if li_detinv=1 or pv_kanne_muuinfo.yldnimi is null or Trim(pv_kanne_muuinfo.yldnimi)='' then pv_kanne.nimi else pv_kanne_muuinfo.yldnimi endif,
        get_pv_protsent("pv_kanne"."id",years(a_kuup),month(a_kuup)),
       (if li_info = 1 then (if pv_kanne."info" is null then '' else pv_kanne.info endif) else '' endif),
       (if li_tunnus = 1 then (if pv_kanne."tunnus" is null then '' else pv_kanne.tunnus endif) else '' endif),
        pv_kanne.kuup,
        pv_kanne.ekspl,
        pv_kanne.invent,
        if pv_kanne.kogus is null then 1 else pv_kanne.kogus endif,
        pv_kanne.alg_m,
        pv_epk(pv_kanne.id,years(a_kuup)) as epk,
        pv_jpk(pv_kanne.id,years(a_kuup),month(a_kuup)-1,epk)+(if years(pv_kanne.kuup)=years(a_kuup) and pv_kanne.kuup<ymd(Years(a_kuup),Month(a_kuup),1) then pv_kanne.ytk else 0 endif) as jpk1,
        pv_jpk(pv_kanne.id,years(a_kuup),month(a_kuup),epk)+(if years(pv_kanne.kuup)=years(a_kuup) and pv_kanne.kuup<ymd(Years(a_kuup),Month(a_kuup)+1,1) then pv_kanne.ytk else 0 endif) as jpk2
      from pv_kanne left outer join gl_1 on(pv_kanne.id = gl_1.id) and(pv_kanne.kuup = gl_1.kuup)
                    left outer join pv_yksus on pv_kanne.yksusnr = pv_yksus.yksusnr
                    left outer join pv_kanne_muuinfo on pv_kanne.yldnimnr=pv_kanne_muuinfo.id
      where((pv_kanne.id = gl_1.id) and(pv_kanne.kuup = gl_1.kuup) or a_paring = 0) and(pv_yksus.skoop = a_skoop or a_skoop = 0) and(pv_kanne.yksusnr = a_yksusnr or a_yksusnr = 0) and Left(pv_yksus.kood,Length(a_yksuskood))=a_yksuskood and(pv_yksus.asutnr = a_asutnr or a_asutnr = 0) and pv_kanne.kuup <= a_kuup and(pv_kanne.objnr2 is null or pv_kanne.kuup2 > a_kuup)
      order by "pv_kanne"."id" asc;
  declare c_gl_pv_kanne dynamic scroll cursor for select gl_pv_kanne."id",get_pv_min_id(gl_pv_kanne."id") from gl_pv_kanne;
  declare c_pv_kanne_invinfo dynamic scroll cursor for select pv_kanne_invinfo.info3 from pv_kanne_invinfo where pv_kanne_invinfo.id_pv_kanne=li_id_min and pv_kanne_invinfo.kuup>ld_invkuup;
  declare c_pv_kanne_leping dynamic scroll cursor for select pv_kanne_leping.vara2_nr from pv_kanne_leping where pv_kanne_leping.id_kanne=li_id_min;
  delete from gl_pv_kanne;
  select t_user.tr_inv_tegelik,t_user.tr_inv_raamat,t_user.tr_inv_invent,t_user.tr_inv_info,t_user.tr_inv_tunnus,t_user.tr_inv_kulunud,if t_user.tr_inv_markus_veerg=1 and t_user.tr_inv_markus_fill=1 then 1 else 0 endif,if t_user.tr_inv_vara_veerg=1 and t_user.tr_inv_vara2_veerg=1 then 1 else 0 endif, t_user.tr_inv_detinv into li_tegelik,li_raamat,li_invent,li_info,li_tunnus,li_kulunud,li_inv_markus, li_inv_vara2, li_detinv from t_user where t_user.id_user = a_id_user;
  set ld_invkuup=dateadd(day,-1*li_invent,a_kuup);
  set li_paring=set_gl_1(a_paring);
  open c_pv_kanne;
  pv_kanne_loop: loop
    fetch next c_pv_kanne into li_id,li_yldnimnr,li_yksusnr,ls_konto,ls_toot_nr,ls_vara_nr,ls_nimi,ls_yldnimi,ldc_kulu_p,ls_info,ls_tunnus,ld_kuup,ld_ekspl,ld_invent,ldc_kogus,ldc_summa,ldc_epk,ldc_jpk1,ldc_jpk2;
    if sqlstate = err_notfound then -- kui eof
      leave pv_kanne_loop
    end if;
    if li_tegelik = 2 then
      if ld_invent > ld_invkuup then
        set ldc_teg_kogus=ldc_kogus;
        set ldc_teg_summa=ldc_summa
      else
        set ldc_teg_kogus=0;
        set ldc_teg_summa=0
      end if
    elseif li_tegelik = 1 then
      set ldc_teg_kogus=ldc_kogus;
      set ldc_teg_summa=ldc_summa
    else
      set ldc_teg_kogus=0;
      set ldc_teg_summa=0
    end if;
    if li_raamat = 1 then
      set ldc_raamat_kogus=ldc_kogus;
      set ldc_raamat_summa=ldc_summa
    else
      set ldc_raamat_kogus=0;
      set ldc_raamat_summa=0
    end if;
    -- kulunud
    if li_kulunud = 1 then
      -- jaakmaksumus
      set ldc_mjm=ldc_summa-ldc_epk-ldc_jpk2;
      -- kuu kulum
      set ldc_jpk=ldc_jpk2-ldc_jpk1;
      -- kui kuu kulum ei ole null, siis mitu kuud jaab veel kuluda
      if ldc_jpk <> 0 and ldc_mjm > 0 then
        set li_kuid=ceiling(ldc_mjm/ldc_jpk);
        -- jagatakse tagasi aastad
        set li_kulunud_a=floor(li_kuid/12);
        -- arvutatakse kuu
        set li_kulunud_k=month(a_kuup)+(li_kuid-(li_kulunud_a*12));
        if li_kulunud_k > 12 then
          set li_kulunud_a=li_kulunud_a+1;
          set li_kulunud_k=li_kulunud_k-12
        end if;
        -- arvutatakse aasta
        set li_kulunud_a=li_kulunud_a+years(a_kuup)
      else
        set li_kuid=0;
        set li_kulunud_k=0;
        set li_kulunud_a=0
      end if
    else
      set li_kuid=0;
      set li_kulunud_k=0;
      set li_kulunud_a=0
    end if;
    -- korduv kanne
    set li_id_min=null;
    if li_yldnimnr is not null then
      select first id into li_id_min from gl_pv_kanne where yldnimnr=li_yldnimnr;
    else
      if Length(ls_toot_nr)>0 then
        select first id into li_id_min from gl_pv_kanne where toot_nr=ls_toot_nr
      end if;
    end if;
    -- kui detailne vi esimene kanne
    if li_detinv=1 or li_id_min is null then
      insert into gl_pv_kanne( id,yldnimnr,yksusnr,konto,toot_nr,vara_nr,nimi,yldnimi,kulu_p,"info",tunnus,kuup,ekspl,kogus,alg_m,teg_kogus,teg_alg_m,kulunud_k,kulunud_a,mjm,info3,invent)
                       values( li_id,li_yldnimnr,li_yksusnr,ls_konto,ls_toot_nr,ls_vara_nr,ls_nimi,ls_yldnimi,ldc_kulu_p,ls_info,ls_tunnus,ld_kuup,ld_ekspl,ldc_raamat_kogus,ldc_raamat_summa,ldc_teg_kogus,ldc_teg_summa,li_kulunud_k,li_kulunud_a,ldc_summa-ldc_epk-ldc_jpk2,'',ld_invent);
    else
      -- summeerimine
      update gl_pv_kanne set alg_m = alg_m+ldc_raamat_summa,teg_alg_m = teg_alg_m+ldc_teg_summa, mjm=mjm+(ldc_summa-ldc_epk-ldc_jpk2), "info"=Left(Trim("info"+' '+ls_info),250), "tunnus"=Left(Trim("tunnus"+' '+ls_tunnus),100) where gl_pv_kanne.id=li_id_min;
      -- kulunud
      if li_kulunud = 1 then
        update gl_pv_kanne set kulunud_k = li_kulunud_k,kulunud_a = li_kulunud_a where gl_pv_kanne.id=li_id_min and(gl_pv_kanne.kulunud_a < li_kulunud_a or(gl_pv_kanne.kulunud_a = li_kulunud_a and gl_pv_kanne.kulunud_k < li_kulunud_k))
      end if
    end if;
  end loop pv_kanne_loop;
  close c_pv_kanne;
  if li_inv_markus=1 then
    open c_gl_pv_kanne;
    gl_pv_kanne_loop: loop
      fetch next c_gl_pv_kanne into li_id,li_id_min;
      if sqlstate = err_notfound then -- kui eof
        leave gl_pv_kanne_loop
      end if;
      open c_pv_kanne_invinfo;
      pv_kanne_invinfo_loop: loop
        fetch next c_pv_kanne_invinfo into ls_info3;
        if sqlstate = err_notfound then -- kui eof
          leave pv_kanne_invinfo_loop
        end if;
        update gl_pv_kanne set gl_pv_kanne.info3=left(gl_pv_kanne.info3+' '+ls_info3,2000) where gl_pv_kanne.id=li_id;
      end loop pv_kanne_invinfo_loop;
      close c_pv_kanne_invinfo
    end loop gl_pv_kanne_loop;
    close c_gl_pv_kanne;
  end if;
  if li_inv_vara2=1 then
    open c_gl_pv_kanne;
    gl_pv_kanne2_loop: loop
      fetch next c_gl_pv_kanne into li_id,li_id_min;
      if sqlstate = err_notfound then -- kui eof
        leave gl_pv_kanne2_loop
      end if;
      open c_pv_kanne_leping;
      pv_kanne_leping_loop: loop
        fetch next c_pv_kanne_leping into ls_info3;
        if sqlstate = err_notfound then -- kui eof
          leave pv_kanne_leping_loop
        end if;
        update gl_pv_kanne set gl_pv_kanne.vara2_nr=left(gl_pv_kanne.vara2_nr+' '+ls_info3,100) where gl_pv_kanne.id=li_id;
      end loop pv_kanne_leping_loop;
      close c_pv_kanne_leping
    end loop gl_pv_kanne2_loop;
    close c_gl_pv_kanne;
  end if
end