CREATE PROCEDURE "DBA"."pv_koond_org"( in a_skoop integer, in a_orgnr integer )
RESULT( yksus_konto char(7), konto_nimi char(100), yldnimnr integer, yldnimi char(200), id integer, inv_nr char(20), nimi char(100), kuup date, protsent decimal(7,3), summa decimal(15,2), epk decimal(15,2), jpk2 decimal(15,2), mjm decimal(15,2))
BEGIN
  declare ld_perlop date;
  set ld_perlop=ToDay();
  delete from gl_pv_kanne;
  insert into gl_pv_kanne(yksusnr,"id",toot_nr,nimi,yldnimnr,yldnimi,kuup,kulu_p,alg_m,epk,jpk2)
    select pv_kanne.yksusnr,
           pv_kanne."id",
           if pv_kanne.toot_nr is null then '' else pv_kanne.toot_nr endif,
           pv_kanne.nimi,
           if pv_kanne.yldnimnr is null then 0 else pv_kanne.yldnimnr endif,
           if pv_kanne.yldnimnr is null then ' Varad' else Trim(pv_kanne_muuinfo.yldnimi) endif,
           pv_kanne.kuup,
           get_pv_protsent(pv_kanne."id",years(ld_perlop),month(ld_perlop)),
           pv_kanne.alg_m,
           pv_epk(pv_kanne."id",years(ld_perlop)) as c_epk,
           pv_jpk(pv_kanne."id",years(ld_perlop),month(ld_perlop),c_epk)+(if years(pv_kanne.kuup)=years(ld_perlop) and pv_kanne.kuup<ymd(Years(ld_perlop),Month(ld_perlop)+1,1) then pv_kanne.ytk else 0 endif) as c_jpk2
      from pv_kanne left outer join pv_yksus on pv_kanne.yksusnr = pv_yksus.yksusnr
                    left outer join pv_kanne_muuinfo on pv_kanne.yldnimnr=pv_kanne_muuinfo."id"
      where (pv_yksus.skoop = a_skoop or a_skoop = 0) and
            (pv_yksus.orgnr = a_orgnr) and
            (pv_kanne.kuup <= ld_perlop) and
            (pv_kanne.objnr2 is null or(pv_kanne.objnr2 is not null and pv_kanne.kuup2>ld_perlop));
  select if pv_yksus.konto is null then 'Varad' else pv_yksus.konto endif as yksus_konto,
         if pv_yksus.konto is null then 'Muud varad' else kontlist.nimi endif,
         gl_pv_kanne.yldnimnr,gl_pv_kanne.yldnimi,
         gl_pv_kanne."id",gl_pv_kanne.toot_nr,gl_pv_kanne.nimi,
         gl_pv_kanne.kuup,gl_pv_kanne.kulu_p,
         gl_pv_kanne.alg_m,gl_pv_kanne.epk,gl_pv_kanne.jpk2,
         gl_pv_kanne.alg_m-gl_pv_kanne.epk-gl_pv_kanne.jpk2 as c_mjm
    from gl_pv_kanne left outer join pv_yksus on gl_pv_kanne.yksusnr = pv_yksus.yksusnr,
            pv_yksus left outer join kontlist on pv_yksus.konto=kontlist.konto
    order by yksus_konto,gl_pv_kanne.yldnimi,gl_pv_kanne.yldnimnr,gl_pv_kanne.nimi,gl_pv_kanne."id";
END